package de.fzi.wim.oimodeler.sidebar;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComponent;

import edu.unika.aifb.kaon.api.*;

import de.fzi.wim.guibase.sidebar.*;

import de.fzi.wim.oimodeler.ui.*;

/**
 * The refinement of the stock sidebar component for the OI-modeler.
 */
public class OIModelerSideBar extends JSideBar {
    /** The viewable of the OI-modeler. */
    protected OIModelerViewable m_oimodelerViewable;

    /**
     * Creates an instance of this class.
     *
     * @param oimodelerViewable                 the OI-modeler viewable
     */
    public OIModelerSideBar(OIModelerViewable oimodelerViewable) {
        m_oimodelerViewable=oimodelerViewable;
    }
    /**
     * Sets the language of the sidebar.
     *
     * @param languageURI                       the URI of the language
     * @throws KAONException                    thrown if there is an error
     */
    public void setLanguageURI(String languageURI) throws KAONException {
        for (int i=0;i<getItemCount();i++) {
            SideBarElement sideBarElement=getSideBarElement(i);
            if (sideBarElement!=null) {
                sideBarElement.setLanguageURI(languageURI);
                setItemLabel(i,sideBarElement.getLabel());
                setItemDescription(i,sideBarElement.getDescription());
                setItemIcon(i,sideBarElement.getIcon());
            }
        }
    }
    /**
     * Removes the item with the supplied index.
     *
     * @param index                         index of the item to be removed
     */
    public void removeItem(int index) {
        SideBarElement sideBarElement=getSideBarElement(index);
        super.removeItem(index);
        if (sideBarElement!=null)
            sideBarElement.removedFromSideBar();
    }
    /**
     * Adds a sidebar element to the sidebar.
     *
     * @param element                       the element
     * @param isRemovable                   <code>true</code> if the element is removable
     */
    public void addElement(SideBarElement element,boolean isRemovable) {
        JComponent component=element.getComponent();
        component.putClientProperty("sidebar.element",element);
        addItem(element.getLabel(),element.getIcon(),element.getDescription(),component,isRemovable);
    }
    /**
     * Returns the sidebar element for given index.
     *
     * @param index                         the index
     * @return                              sidebar element for given index (or <code>null</code> if element wasn't registered)
     */
    protected SideBarElement getSideBarElement(int index) {
        Component component=getItemComponent(index);
        if (component instanceof JComponent)
            return (SideBarElement)((JComponent)component).getClientProperty("sidebar.element");
        else
            return null;
    }

    /**
     * Should be implemented by all elements in the sidebar.
     */
    public interface SideBarElement {
        /**
         * Called to change the language of the element.
         *
         * @param languageURI                       the URI of the language
         * @throws KAONException                    thrown if there is an error
         */
        void setLanguageURI(String languageURI) throws KAONException;
        /**
         * Returns the label of the element.
         *
         * @return                                  the name of the element
         */
        String getLabel();
        /**
         * Returns the description of the element.
         *
         * @return                                  the description of the element
         */
        String getDescription();
        /**
         * Returns the icon of the element.
         *
         * @return                                  the icon of the element
         */
        Icon getIcon();
        /**
         * Returns the component.
         *
         * @return                                  the component
         */
        JComponent getComponent();
        /**
         * Called when the element is evicted from the sidebar.
         */
        void removedFromSideBar();
    }
}
