package de.fzi.wim.oimodeler.selection;

import java.util.Collection;
import java.util.Iterator;

import edu.unika.aifb.kaon.api.oimodel.*;

import de.fzi.wim.guibase.selectionsource.*;
import de.fzi.wim.oimodeler.lexicon.*;
import de.fzi.wim.oimodeler.inclusion.*;

/**
 * The selection source for the OI-modeler.
 */
public class OIModelerSelectionSourceManager extends SelectionSourceManager {
    /** The flag specifying that the selection contains concepts. */
    public static final int CONTAINS_CONCEPTS=0x01;
    /** The flag specifying that the selection contains properties. */
    public static final int CONTAINS_PROPERTIES=0x02;
    /** The flag specifying that the selection contains instances. */
    public static final int CONTAINS_INSTANCES=0x04;
    /** The flag specifying that the selection contains property instances. */
    public static final int CONTAINS_PROPERTY_INSTANCES=0x08;
    /** The flag specifying that the selection contains lexical references. */
    public static final int CONTAINS_LEXICAL_REFERENCES=0x10;
    /** The flag specifying that the selection contains OI-models. */
    public static final int CONTAINS_OIMODELS=0x20;

    /** The type of the current selection. */
    protected int m_activeSelectionType;

    /**
     * Returns the type of the active selection.
     *
     * @return                              the type of the active selection
     */
    public int getActiveSelectionType() {
        return m_activeSelectionType;
    }
    /**
     * Reloads the active selection from the active selection source.
     */
    protected void reloadActiveSelection() {
        super.reloadActiveSelection();
        m_activeSelectionType=getSelectionType(m_activeSelection);
    }
    /**
     * Returns the type of the selection.
     *
     * @param selection                     the selection
     * @return                              the type of the selection
     */
    public static int getSelectionType(Collection selection) {
        int selectionType=0;
        Iterator iterator=selection.iterator();
        while (iterator.hasNext()) {
            Object object=iterator.next();
            if (object instanceof Concept)
                selectionType|=CONTAINS_CONCEPTS;
            else if (object instanceof Property)
                selectionType|=CONTAINS_PROPERTIES;
            else if (object instanceof Instance)
                selectionType|=CONTAINS_INSTANCES;
            else if (object instanceof PropertyInstance)
                selectionType|=CONTAINS_PROPERTY_INSTANCES;
            else if (object instanceof LexiconTable.LexiconSelection)
                selectionType|=CONTAINS_LEXICAL_REFERENCES;
            else if (object instanceof OIModelInclusionTreeModel.OIModelNode)
                selectionType|=CONTAINS_OIMODELS;
        }
        return selectionType;
    }
}
