package de.fzi.wim.oimodeler.selection;

import java.util.Set;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Collection;

import edu.unika.aifb.kaon.api.oimodel.*;

import de.fzi.wim.guibase.graphview.graph.*;
import de.fzi.wim.guibase.graphview.selection.*;

import de.fzi.wim.oimodeler.oimodelgraph.graph.*;

/**
 * Represents a node selection model that mimics the OIModeler selection model.
 */
public class OIModelerNodeSelectionModel extends DefaultNodeSelectionModel implements OIModelerSelectionListener {
    /** Set to <code>true</code> if the model is currently being updated. */
    protected boolean m_updatingModel;
    /** Set to <code>true</code> if the OI-modeler selection model is currently being updated. */
    protected boolean m_oimodelerSelectionModelUpdating;
    /** The OI-modeler selection model. */
    protected OIModelerSelectionModel m_oimodelerSelectionModel;

    /**
     * Creates a selection model.
     *
     * @param oimodelGraph                          the OI-model graph
     * @param oimodelerSelectionModel               the OI-modeler selection model
     */
    public OIModelerNodeSelectionModel(OIModelGraph oimodelGraph,OIModelerSelectionModel oimodelerSelectionModel) {
        super(oimodelGraph);
        m_oimodelerSelectionModel=oimodelerSelectionModel;
        m_oimodelerSelectionModel.addOIModelSelectionListener(this);
    }
    /**
     * Clears the selection.
     */
    public void clear() {
        if (!m_selectedNodes.isEmpty()) {
            m_selectedNodes.clear();
            fireSelectionCleared();
            m_updatingModel=true;
            m_oimodelerSelectionModel.clearSelectedEntities();
            m_updatingModel=false;
        }
    }
    /**
     * Adds a collection of nodes to the selection.
     *
     * @param nodes                         the collection of nodes to add to the selection
     */
    public void addNodes(Collection nodes) {
        if (m_selectedNodes.addAll(nodes)) {
            fireNodesAddedToSelection(nodes);
            updateOIModelerSelectionModel();
        }
    }
    /**
     * Removes a collection of nodes from the selection.
     *
     * @param nodes                         the collection of nodes to remove from the selection
     */
    public void removeNodes(Collection nodes) {
        if (m_selectedNodes.removeAll(nodes)) {
            fireNodesRemovedFromSelection(nodes);
            updateOIModelerSelectionModel();
        }
    }
    /**
     * Called when the selected entities change.
     *
     * @param oimodelSelectionModel             the selection model
     */
    public void selectedEntitiesChanged(OIModelerSelectionModel oimodelSelectionModel) {
        if (!m_updatingModel) {
            m_oimodelerSelectionModelUpdating=true;
            OIModelGraph oimodelGraph=(OIModelGraph)m_graph;
            Set selectedEntities=oimodelSelectionModel.getSelectedEntities();
            Iterator selection=selectedEntities.iterator();
            Set addedNodes=null;
            while (selection.hasNext()) {
                Entity entity=(Entity)selection.next();
                EntityNode entityNode=oimodelGraph.getNodeForEntity(entity);
                if (entityNode!=null && !isNodeSelected(entityNode)) {
                    if (addedNodes==null)
                        addedNodes=new HashSet();
                    addedNodes.add(entityNode);
                }
            }
            if (addedNodes!=null)
                addNodes(addedNodes);
            Set removedNodes=null;
            selection=getSelectedNodes().iterator();
            while (selection.hasNext()) {
                Node node=(Node)selection.next();
                if (node instanceof EntityNode) {
                    EntityNode entityNode=(EntityNode)node;
                    Entity entity=entityNode.getEntity();
                    if (!selectedEntities.contains(entity)) {
                        if (removedNodes==null)
                            removedNodes=new HashSet();
                        removedNodes.add(entityNode);
                    }
                }
            }
            if (removedNodes!=null)
                removeNodes(removedNodes);
            m_oimodelerSelectionModelUpdating=false;
        }
    }
    /**
     * Updates the selection model of the OI-modeler.
     */
    protected void updateOIModelerSelectionModel() {
        if (!m_oimodelerSelectionModelUpdating) {
            m_updatingModel=true;
            Set set=new HashSet();
            Iterator iterator=m_selectedNodes.iterator();
            while (iterator.hasNext()) {
                Node node=(Node)iterator.next();
                if (node instanceof EntityNode) {
                    EntityNode entityNode=(EntityNode)node;
                    set.add(entityNode.getEntity());
                    ((OIModelGraph)m_graph).moveIntoForeground(node);
                }
            }
            m_oimodelerSelectionModel.setSelectedEntities(set);
            m_updatingModel=false;
        }
    }
}
