package de.fzi.wim.oimodeler.selection;

import java.util.Iterator;
import java.util.Collection;
import java.awt.event.MouseEvent;
import java.awt.event.MouseAdapter;
import javax.swing.JTree;

import edu.unika.aifb.kaon.api.oimodel.*;

import de.fzi.wim.guibase.selectionsource.*;

import de.fzi.wim.oimodeler.ui.*;

/**
 * When attached to the selector, this object will on double click focuses the selection.
 */
public class DoubleClickSelectionFocuser extends MouseAdapter {
    /** The OI-modeler viewable. */
    protected OIModelerViewable m_oimodelerViewable;
    /** The selection source. */
    protected SelectionSource m_selectionSource;

    /**
     * Creates an instance of this class.
     *
     * @param oimodelerViewable     the OI-modeler viewable
     * @param selectionSource       the selection source
     */
    public DoubleClickSelectionFocuser(OIModelerViewable oimodelerViewable,SelectionSource selectionSource) {
        m_oimodelerViewable=oimodelerViewable;
        m_selectionSource=selectionSource;
        m_selectionSource.getComponent().addMouseListener(this);
        // this is to prevent the tree from opening or closing nodes needlesly on double clicks
        if (m_selectionSource.getComponent() instanceof JTree)
            ((JTree)m_selectionSource.getComponent()).setToggleClickCount(5);
    }
    /**
     * Called when mouse is clicked.
     *
     * @param e                     the event
     */
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount()>=2) {
            Collection selection=m_selectionSource.getSelection();
            if (!selection.isEmpty()) {
                boolean hasAtLeastOneEntity=false;
                Iterator iterator=selection.iterator();
                while (iterator.hasNext()) {
                    Object object=iterator.next();
                    if (object instanceof Entity) {
                        hasAtLeastOneEntity=true;
                        break;
                    }
                }
                if (hasAtLeastOneEntity)
                    m_oimodelerViewable.getOIModelerSelectionModel().setSelectedEntities(selection);
            }
        }
    }
}
