package de.fzi.wim.oimodeler.search;

import java.util.ArrayList;
import java.util.List;
import java.util.Iterator;
import java.util.Collection;
import java.util.Collections;
import javax.swing.SwingUtilities;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;

import de.fzi.wim.oimodeler.ui.*;
import de.fzi.wim.oimodeler.entitylist.*;

/**
 * The table model for displaying the property list.
 */
public class OIModelSearchTableModel extends OIModelEntityTableModel {
    /** The counter of serach requests. */
    protected int m_searchRequestCounter;

    /**
     * Creates an instance of this class.
     *
     * @param oimodelerViewable             the viewable
     */
    public OIModelSearchTableModel(OIModelerViewable oimodelerViewable) {
        super(oimodelerViewable);
    }
    /**
     * Searches the lexicon and produces a list of entries with given lexical value.
     *
     * @param lexicalValue                      the lexical value
     * @param showConcepts                      if <code>true</code> concepts will be shown
     * @param showProperties                    if <code>true</code> properties will be shown
     * @param showInstances                     if <code>true</code> instances will be shown
     * @throws KAONException                    thrown if there is a problem
     */
    public void searchLexicon(final String lexicalValue,final boolean showConcepts,final boolean showProperties,final boolean showInstances) throws KAONException {
        final int searchRequestCounter=m_searchRequestCounter++;
        m_elements=null;
        fireTableDataChanged();
        try {
            m_oimodelerViewable.getModule().getAppDriver().getThreadPool().executeTask(new Runnable() {
                public void run() {
                    try {
                        final List elements=new ArrayList();
                        String languageCode=m_oimodelerViewable.getLanguageURI();
                        languageCode=languageCode.substring(languageCode.length()-2);
                        String encodedValue=encodeApostrophes(lexicalValue.trim());
                        Collection answer=m_oimodelerViewable.getOIModel().executeQuery("HAS_LABEL('"+encodedValue+"','"+languageCode+"') OR HAS_LEXICON('Synonym','"+encodedValue+"','"+languageCode+"')");
                        m_oimodelerViewable.getOIModel().loadObjects(answer,OIModel.LOAD_CONCEPT_BASICS | OIModel.LOAD_PROPERTY_BASICS | OIModel.LOAD_INSTANCE_BASICS | OIModel.LOAD_LEXICON);
                        Iterator iterator=answer.iterator();
                        while (iterator.hasNext()) {
                            Instance instance=(Instance)iterator.next();
                            if (showInstances)
                                elements.add(new TableRow(instance));
                            if (showConcepts) {
                                Concept concept=instance.getSpanningConcept();
                                if (concept.isInOIModel())
                                    elements.add(new TableRow(concept));
                            }
                            if (showProperties) {
                                Property property=instance.getSpanningProperty();
                                if (property.isInOIModel())
                                    elements.add(new TableRow(property));
                            }
                        }
                        Collections.sort(elements,RowComparator.INSTANCE);
                        SwingUtilities.invokeLater(new Runnable() {
                            public void run() {
                                if (searchRequestCounter==searchRequestCounter && m_elements==null) {
                                    m_elements=elements;
                                    fireTableDataChanged();
                                }
                            }
                        });
                    }
                    catch (final KAONException e) {
                        SwingUtilities.invokeLater(new Runnable() {
                            public void run() {
                                if (searchRequestCounter==searchRequestCounter && m_elements==null) {
                                    m_elements=new ArrayList();
                                    fireTableDataChanged();
                                }
                                m_oimodelerViewable.getModule().getAppDriver().displayErrorNotification(e);
                            }
                        });
                    }
                }
            });
        }
        catch (InterruptedException e) {
            throw new KAONException("Thread interrupted.",e);
        }
    }
    /**
     * Executes the specified query on the OI-model.
     *
     * @param queryString                       the query to be executed
     * @throws KAONException                    thrown if there is a problem
     */
    public void executeQuery(final String queryString) throws KAONException {
        final int searchRequestCounter=m_searchRequestCounter++;
        m_elements=null;
        fireTableDataChanged();
        try {
            m_oimodelerViewable.getModule().getAppDriver().getThreadPool().executeTask(new Runnable() {
                public void run() {
                    try {
                        final List elements=new ArrayList();
                        Collection answer=m_oimodelerViewable.getOIModel().executeQuery(queryString);
                        m_oimodelerViewable.getOIModel().loadObjects(answer,OIModel.LOAD_CONCEPT_BASICS | OIModel.LOAD_PROPERTY_BASICS | OIModel.LOAD_INSTANCE_BASICS | OIModel.LOAD_LEXICON);
                        Iterator iterator=answer.iterator();
                        while (iterator.hasNext()) {
                            Object object=iterator.next();
                            if (object instanceof Instance)
                                elements.add(new TableRow((Instance)object));
                        }
                        Collections.sort(elements,RowComparator.INSTANCE);
                        SwingUtilities.invokeLater(new Runnable() {
                            public void run() {
                                if (searchRequestCounter==searchRequestCounter && m_elements==null) {
                                    m_elements=elements;
                                    fireTableDataChanged();
                                }
                            }
                        });
                    }
                    catch (final KAONException e) {
                        SwingUtilities.invokeLater(new Runnable() {
                            public void run() {
                                if (searchRequestCounter==searchRequestCounter && m_elements==null) {
                                    m_elements=new ArrayList();
                                    fireTableDataChanged();
                                }
                                m_oimodelerViewable.getModule().getAppDriver().displayErrorNotification(e);
                            }
                        });
                    }
                }
            });
        }
        catch (InterruptedException e) {
            throw new KAONException("Thread interrupted.",e);
        }
    }
    /**
     * Encodes the apostrophes in a literal according to the KAON query requirements.
     *
     * @param value                             the value to be encoded
     * @return                                  the encoded value
     */
    protected static String encodeApostrophes(String value) {
        int apostrophePosition=value.indexOf('\'');
        while (apostrophePosition!=-1) {
            value=value.substring(0,apostrophePosition)+"'"+value.substring(apostrophePosition);
            apostrophePosition=value.indexOf('\'',apostrophePosition+2);
        }
        return value;
    }
}
