package de.fzi.wim.oimodeler.oimodelgraph.view;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.BasicStroke;

import de.fzi.wim.guibase.graphview.graph.*;
import de.fzi.wim.guibase.graphview.controller.*;
import de.fzi.wim.guibase.graphview.view.*;

/**
 * The painter for spanning object edges.
 */
public class SpanningObjectEdgePainter extends AbstractEdgePainter {
    /** An instance. */
    public static final EdgePainter INSTANCE=new SpanningObjectEdgePainter();

    /** The stroke to be used. */
    protected Stroke m_stroke=new BasicStroke(1.0f,BasicStroke.CAP_BUTT,BasicStroke.JOIN_BEVEL,0.0f,new float[] { 15.0f,5.0f },0.0f);
    /**
     * Paints the supplied edge.
     *
     * @param graphPane             the graph pane
     * @param g                     the graphics
     * @param edge                  the edge to paint
     */
    public void paintEdge(JGraphPane graphPane,Graphics2D g,Edge edge) {
        HighlightingManipulator highlightingManipulator=(HighlightingManipulator)graphPane.getManipulator(HighlightingManipulator.NAME);
        boolean isHighlighted=highlightingManipulator!=null && highlightingManipulator.getHighlightedEdge()==edge;
        DraggingManipulator draggingManipulator=(DraggingManipulator)graphPane.getManipulator(DraggingManipulator.NAME);
        boolean isDragging=draggingManipulator!=null && draggingManipulator.getDraggedEdge()==edge;
        Point from=graphPane.getScreenPointForNode(edge.getFrom());
        Point to=graphPane.getScreenPointForNode(edge.getTo());
        Stroke oldStroke=g.getStroke();
        g.setStroke(m_stroke);
        Color oldColor=g.getColor();
        g.setColor(getEdgeColor(edge,isHighlighted,isDragging));
        g.drawLine(from.x,from.y,to.x,to.y);
        g.setColor(oldColor);
        g.setStroke(oldStroke);
    }
    /**
     * Returns the color for the edge.
     *
     * @param edge                  the edge to be painted
     * @param isHighlighted         <code>true</code> if the edge is highlighted
     * @param isDragging            <code>true</code> if the edge is being dragged
     * @return                      the color for the edge
     */
    protected Color getEdgeColor(Edge edge,boolean isHighlighted,boolean isDragging) {
        if (isHighlighted || isDragging)
            return Color.red;
        else
            return Color.gray;
    }
}
