package de.fzi.wim.oimodeler.oimodelgraph.view;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;

import de.fzi.wim.guibase.graphview.graph.*;
import de.fzi.wim.guibase.graphview.controller.*;
import de.fzi.wim.guibase.graphview.view.*;

import de.fzi.wim.oimodeler.oimodelgraph.graph.*;

/**
 * The painter for property instance edges.
 */
public class PropertyInstanceEdgePainter extends AbstractEdgePainter {
    /** An instance. */
    public static final EdgePainter INSTANCE=new PropertyInstanceEdgePainter();

    /**
     * Paints the supplied edge.
     *
     * @param graphPane             the graph pane
     * @param g                     the graphics
     * @param edge                  the edge to paint
     */
    public void paintEdge(JGraphPane graphPane,Graphics2D g,Edge edge) {
        HighlightingManipulator highlightingManipulator=(HighlightingManipulator)graphPane.getManipulator(HighlightingManipulator.NAME);
        boolean isHighlighted=highlightingManipulator!=null && highlightingManipulator.getHighlightedEdge()==edge;
        DraggingManipulator draggingManipulator=(DraggingManipulator)graphPane.getManipulator(DraggingManipulator.NAME);
        boolean isDragging=draggingManipulator!=null && draggingManipulator.getDraggedEdge()==edge;
        Point from=graphPane.getScreenPointForNode(edge.getFrom());
        Point to=graphPane.getScreenPointForNode(edge.getTo());
        Color oldColor=g.getColor();
        g.setColor(getEdgeColor(edge,isHighlighted,isDragging));
        if (edge.getTo() instanceof PropertyInstancesNode)
            g.drawLine(from.x,from.y,to.x,to.y);
        else
            DomainRangeEdgePainter.paintArrow(g,from.x,from.y,to.x,to.y);
        g.setColor(oldColor);
    }
    /**
     * Returns the color for the edge.
     *
     * @param edge                  the edge to be painted
     * @param isHighlighted         <code>true</code> if the edge is highlighted
     * @param isDragging            <code>true</code> if the edge is being dragged
     * @return                      the color for the edge
     */
    protected Color getEdgeColor(Edge edge,boolean isHighlighted,boolean isDragging) {
        if (isHighlighted || isDragging)
            return Color.red;
        else
            return Color.black;
    }
}
