package de.fzi.wim.oimodeler.oimodelgraph.view;

import de.fzi.wim.guibase.graphview.graph.*;
import de.fzi.wim.guibase.graphview.controller.*;

import de.fzi.wim.oimodeler.ui.*;
import de.fzi.wim.oimodeler.selection.*;
import de.fzi.wim.oimodeler.oimodelgraph.graph.*;
import de.fzi.wim.oimodeler.oimodelgraph.controller.*;

/**
 * A graph pane for rendering OI-models.
 */
public class OIModelGraphPane extends BasicOIModelGraphPane {
   /**
    * Creates a graph pane.
    *
    * @param oimodelGraph               the OI-model graph
    * @param oimodelerViewable          the OI-modeler viewable
    */
    public OIModelGraphPane(OIModelGraph oimodelGraph,OIModelerViewable oimodelerViewable) {
        super(oimodelGraph);
        addManipulator(new IncrementalSearchManipulator(getOIModelGraphAnchor().getLocalizationManager().getPhrase("oimodeler.searchForLabel")));
        addManipulator(new HighlightingManipulator());
        addManipulator(new NodeExpansionManipulator(getOIModelGraphAnchor()));
        addManipulator(new AttributeEditorManipulator(getOIModelGraphAnchor()));
        addManipulator(new SelectionManipulator(new OIModelerNodeSelectionModel(oimodelGraph,oimodelerViewable.getOIModelerSelectionModel())) {
            protected boolean shouldSelectNode(Node node) {
                return node instanceof EntityNode;
            }
        });
        addManipulator(new DraggingManipulator());
        addManipulator(new BackgroundDraggingManipulator());
        addManipulator(new ConnectionManipulator(getOIModelGraphAnchor()));
        addManipulator(new ContextMenuManipulator(oimodelerViewable));
        setSelectionSourceManager(oimodelerViewable.getOIModelerSelectionSourceManager());
    }
}
