package de.fzi.wim.oimodeler.oimodelgraph.view;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;

import de.fzi.wim.guibase.graphview.graph.*;
import de.fzi.wim.guibase.graphview.view.*;

/**
 * The painter for fan out nodes.
 */
public class FanOutNodePainter implements NodePainter {
    /** An instance. */
    public static final NodePainter INSTANCE=new FanOutNodePainter();
    /** The width of the proxy node. */
    protected static final int WIDTH=6;
    /** The height of the proxy node. */
    protected static final int HEIGHT=6;

    /**
     * Paints the supplied node.
     *
     * @param graphPane             the graph pane
     * @param g                     the graphics
     * @param node                  the node to paint
     */
    public void paintNode(JGraphPane graphPane,Graphics2D g,Node node) {
        Color oldColor=g.getColor();
        g.setColor(Color.gray);
        Point nodePoint=graphPane.getScreenPointForNode(node);
        g.fillRect(nodePoint.x-WIDTH/2,nodePoint.y-HEIGHT/2,WIDTH,HEIGHT);
        g.setColor(graphPane.getBackground());
        g.drawRect(nodePoint.x-WIDTH/2,nodePoint.y-HEIGHT/2,WIDTH,HEIGHT);
        g.setColor(oldColor);
    }
    /**
     * Checks whether given point is inside the node.
     *
     * @param graphPane             the graph pane
     * @param node                  the node
     * @param point                 the point
     * @return                      <code>true</code> if the point is in the node
     */
    public boolean isInNode(JGraphPane graphPane,Node node,Point point) {
        Point nodePoint=graphPane.getScreenPointForNode(node);
        return nodePoint.x-WIDTH/2<=point.x && nodePoint.y-HEIGHT/2<=point.y && point.x<=nodePoint.x+WIDTH/2 && point.y<=nodePoint.y+HEIGHT/2;
    }
    /**
     * Returns the outer rectangle of the node on screen.
     *
     * @param graphPane             the graph pane
     * @param node                  the node
     * @param nodeScreenRectangle   the rectangle receiving the node's coordinates
     */
    public void getNodeScreenBounds(JGraphPane graphPane,Node node,Rectangle nodeScreenRectangle) {
        Point nodePoint=graphPane.getScreenPointForNode(node);
        nodeScreenRectangle.setBounds(nodePoint.x-WIDTH/2,nodePoint.y-HEIGHT/2,WIDTH,HEIGHT);
    }
    /**
     * Retruns the tool-tip for given point.
     *
     * @param graphPane             the graph pane
     * @param node                  the node
     * @param point                 the point
     * @return                      the tool-tip at given point (or <code>null</code>)
     */
    public String getToolTipText(JGraphPane graphPane,Node node,Point point) {
        return null;
    }
}
