package de.fzi.wim.oimodeler.oimodelgraph.view;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;

import de.fzi.wim.guibase.graphview.graph.*;
import de.fzi.wim.guibase.graphview.controller.*;
import de.fzi.wim.guibase.graphview.view.*;

import de.fzi.wim.oimodeler.oimodelgraph.graph.*;

/**
 * The painter for domain and range edges.
 */
public class DomainRangeEdgePainter extends AbstractEdgePainter {
    /** An instance. */
    public static final EdgePainter INSTANCE=new DomainRangeEdgePainter();
    /** Square root of 3 over 6. */
    protected static final double SQUARE_ROOT_OF_3_OVER_2=0.866;
    /** The width of the base of the arrow. */
    protected static final double ARROW_BASE_LENGTH=11.0;

    /**
     * Paints the supplied edge.
     *
     * @param graphPane             the graph pane
     * @param g                     the graphics
     * @param edge                  the edge to paint
     */
    public void paintEdge(JGraphPane graphPane,Graphics2D g,Edge edge) {
        HighlightingManipulator highlightingManipulator=(HighlightingManipulator)graphPane.getManipulator(HighlightingManipulator.NAME);
        boolean isHighlighted=highlightingManipulator!=null && highlightingManipulator.getHighlightedEdge()==edge;
        DraggingManipulator draggingManipulator=(DraggingManipulator)graphPane.getManipulator(DraggingManipulator.NAME);
        boolean isDragging=draggingManipulator!=null && draggingManipulator.getDraggedEdge()==edge;
        boolean isShowBlackAndWhite=((BasicOIModelGraphPane)graphPane).getShowBlackAndWhite();
        Point from=graphPane.getScreenPointForNode(edge.getFrom());
        Point to=graphPane.getScreenPointForNode(edge.getTo());
        Color oldColor=g.getColor();
        g.setColor(getEdgeColor(edge,isHighlighted,isDragging,isShowBlackAndWhite));
        paintArrow(g,from.x,from.y,to.x,to.y);
        g.setColor(oldColor);
    }
    /**
     * Returns the color for the edge.
     *
     * @param edge                  the edge to be painted
     * @param isHighlighted         <code>true</code> if the edge is highlighted
     * @param isDragging            <code>true</code> if the edge is being dragged
     * @param isShowBlackAndWhite   <code>true</code> if the graph should be shown in black-and-white
     * @return                      the color for the edge
     */
    protected Color getEdgeColor(Edge edge,boolean isHighlighted,boolean isDragging,boolean isShowBlackAndWhite) {
        if (isShowBlackAndWhite)
            return Color.gray;
        else if (isHighlighted || isDragging)
            return Color.red;
        else {
            if (edge instanceof PropertyDomainEdge)
                return Color.magenta;
            else
                return Color.green;
        }
    }
    /**
     * Draws an arrow at the middle of the edge.
     *
     * @param g                     the graphics to draw on
     * @param x1                    the source x coordinate
     * @param y1                    the source y coordinate
     * @param x2                    the target x coordinate
     * @param y2                    the target y coordinate
     */
    public static void paintArrow(Graphics2D g,int x1,int y1,int x2,int y2) {
        double middleX=(x1+x2)/2;
        double middleY=(y1+y2)/2;
        double slope=Math.atan2(y2-y1,x2-x1);
        double pinnacleX=middleX+SQUARE_ROOT_OF_3_OVER_2*ARROW_BASE_LENGTH*Math.cos(slope);
        double pinnacleY=middleY+SQUARE_ROOT_OF_3_OVER_2*ARROW_BASE_LENGTH*Math.sin(slope);
        double backwardX=pinnacleX+ARROW_BASE_LENGTH*Math.cos(slope+Math.PI+Math.PI/6.0);
        double backwardY=pinnacleY+ARROW_BASE_LENGTH*Math.sin(slope+Math.PI+Math.PI/6.0);
        double forwardX=pinnacleX+ARROW_BASE_LENGTH*Math.cos(slope+Math.PI-Math.PI/6.0);
        double forwardY=pinnacleY+ARROW_BASE_LENGTH*Math.sin(slope+Math.PI-Math.PI/6.0);
        double baseX=(forwardX+backwardX)/2.0;
        double baseY=(forwardY+backwardY)/2.0;
        g.drawLine(x1,y1,(int)baseX,(int)baseY);
        g.drawLine((int)pinnacleX,(int)pinnacleY,x2,y2);
        int[] pointsX=new int[] { (int)backwardX,(int)pinnacleX,(int)forwardX };
        int[] pointsY=new int[] { (int)backwardY,(int)pinnacleY,(int)forwardY };
        g.fillPolygon(pointsX,pointsY,3);
    }
}
