package de.fzi.wim.oimodeler.oimodelgraph.graph;

import edu.unika.aifb.kaon.api.oimodel.*;

/**
 * An edge for depicting the spanning objects in the graph.
 */
public class SpanningObjectEdge extends OIModelEdge {
    /** The unit length of the edge. */
    public static final double UNIT_LENGTH=40.0;

    /**
     * Creates an instance of this class.
     *
     * @param entityNode            the node of the entity
     * @param instanceNode          the node of the instance
     */
    public SpanningObjectEdge(EntityNode entityNode,InstanceNode instanceNode) {
        super(entityNode,instanceNode);
    }
    /**
     * Notifies this edge that it has been hidden in the graph.
     */
    public void notifyHidden() {
        ((EntityNode)getFrom()).m_spanningObjectsExpanded=EntityNode.NOT_LOADED;
        ((InstanceNode)getTo()).m_spanningObjectsExpanded=EntityNode.NOT_LOADED;
    }
    /**
     * Returns the length of this edge.
     *
     * @return                      the ledge of the edge
     */
    public double getLength() {
        return UNIT_LENGTH;
    }
    /**
     * Returns the entity.
     *
     * @return                      the entity
     */
    public Entity getEntity() {
        return ((EntityNode)getFrom()).getEntity();
    }
    /**
     * Returns the instance.
     *
     * @return                      the instance
     */
    public Instance getInstance() {
        return ((InstanceNode)getTo()).getInstance();
    }
    /**
     * Returns the spanning object edge between nodes.
     *
     * @param oimodelGraph          the graph
     * @param entityNode            the node of the entity
     * @param instanceNode          the node of the instance
     * @return                      the edge (if there isn't one, <code>null</code> is returned)
     */
    public static SpanningObjectEdge getEdge(OIModelGraph oimodelGraph,EntityNode entityNode,InstanceNode instanceNode) {
        return (SpanningObjectEdge)oimodelGraph.getEdgeBetweenNodes(entityNode,instanceNode);
    }
}
