package de.fzi.wim.oimodeler.oimodelgraph.graph;

import edu.unika.aifb.kaon.api.oimodel.*;

/**
 * An edge specifying the range of a property in the model.
 */
public class PropertyRangeEdge extends OIModelEdge {
    /** The unit length of the edge. */
    public static final double UNIT_LENGTH=40.0;

    /**
     * Creates an instance of this class.
     *
     * @param propertyNode          the node for which this edge represents the domain
     * @param rangeConceptNode      the range concept of a property
     */
    public PropertyRangeEdge(PropertyNode propertyNode,ConceptNode rangeConceptNode) {
        super(propertyNode,rangeConceptNode);
    }
    /**
     * Notifies this edge that it has been hidden in the graph.
     */
    public void notifyHidden() {
        ((PropertyNode)getFrom()).m_rangeConceptsExpanded=PropertyNode.NOT_LOADED;
        ((ConceptNode)getTo()).m_propertiesToExpanded=ConceptNode.NOT_LOADED;
    }
    /**
     * Returns the length of this edge.
     *
     * @return                      the ledge of the edge
     */
    public double getLength() {
        return UNIT_LENGTH;
    }
    /**
     * Returns the property.
     *
     * @return                      the property
     */
    public Property getProperty() {
        return ((PropertyNode)getFrom()).getProperty();
    }
    /**
     * Returns the concept.
     *
     * @return                      the concept
     */
    public Concept getConcept() {
        return ((ConceptNode)getTo()).getConcept();
    }
    /**
     * Returns the property range edge between nodes.
     *
     * @param oimodelGraph          the graph
     * @param propertyNode          the node for which this edge represents the domain
     * @param rangeConceptNode      the range concept of a property
     * @return                      the edge (if there isn't one, <code>null</code> is returned)
     */
    public static PropertyRangeEdge getEdge(OIModelGraph oimodelGraph,PropertyNode propertyNode,ConceptNode rangeConceptNode) {
        return (PropertyRangeEdge)oimodelGraph.getEdgeBetweenNodes(propertyNode,rangeConceptNode);
    }
}
