package de.fzi.wim.oimodeler.oimodelgraph.graph;

import java.util.Iterator;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Collections;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;

import de.fzi.wim.guibase.graphview.graph.*;

/**
 * An edge for the property instance.
 */
public class PropertyInstanceEdge extends OIModelEdge {
    /** The unit length of the edge. */
    public static final double UNIT_LENGTH=30.0;

    /**
     * Creates an instance of this class.
     *
     * @param from                  the node from wich the edge points
     * @param to                    the node to which the edge points
     */
    public PropertyInstanceEdge(Node from,Node to) {
        super(from,to);
    }
    /**
     * Notifies this edge that it has been hidden in the graph.
     */
    public void notifyHidden() {
    }
    /**
     * Hides the edge in the graph.
     *
     * @param oimodelGraph          the graph
     * @throws KAONException        thrown is there is an error
     */
    public void hideEdge(OIModelGraph oimodelGraph) throws KAONException {
        Collection nodesToRemove;
        InstanceNode instanceNode;
        PropertyInstancesNode propertyInstancesNode;
        if (m_from instanceof InstanceNode) {
            instanceNode=(InstanceNode)m_from;
            propertyInstancesNode=(PropertyInstancesNode)m_to;
            nodesToRemove=new LinkedList(propertyInstancesNode.getTargetNodes());
        }
        else {
            propertyInstancesNode=(PropertyInstancesNode)m_from;
            instanceNode=(InstanceNode)oimodelGraph.getNodeForEntity(propertyInstancesNode.getSourceInstance());
            nodesToRemove=Collections.singleton(m_to);
        }
        instanceNode.m_propertyInstancesFromExpanded=InstanceNode.NOT_LOADED;
        Iterator iterator=nodesToRemove.iterator();
        while (iterator.hasNext()) {
            Object node=(Node)iterator.next();
            PropertyInstance propertyInstance;
            if (node instanceof InstanceNode) {
                InstanceNode targetInstanceNode=(InstanceNode)node;
                targetInstanceNode.m_propertyInstancesToExpanded=InstanceNode.NOT_LOADED;
                Instance targetInstance=targetInstanceNode.getInstance();
                propertyInstance=oimodelGraph.getOIModel().getPropertyInstance(propertyInstancesNode.getProperty(),instanceNode.getInstance(),targetInstance);
            }
            else
                propertyInstance=((LiteralPropertyInstanceValueNode)node).getPropertyInstance();
            instanceNode.removePropertyInstance(oimodelGraph,propertyInstance);
        }
    }
    /**
     * Returns the length of this edge.
     *
     * @return                      the ledge of the edge
     */
    public double getLength() {
        return UNIT_LENGTH;
    }
}
