package de.fzi.wim.oimodeler.oimodelgraph.graph;

import edu.unika.aifb.kaon.api.oimodel.*;

/**
 * An edge for the property hierarchy in the OI-model.
 */
public class PropertyHierarchyEdge extends OIModelEdge {
    /** The unit length of the edge. */
    public static final double UNIT_LENGTH=40.0;

    /** The length of the edge. */
    protected double m_length;

    /**
     * Creates an instance of this class.
     *
     * @param superPropertyNode     the node of the superproperty
     * @param subPropertyNode       the node of the subproperty
     * @param length                the length
     */
    public PropertyHierarchyEdge(PropertyNode superPropertyNode,PropertyNode subPropertyNode,double length) {
        super(subPropertyNode,superPropertyNode);
        m_length=length;
    }
    /**
     * Notifies this edge that it has been hidden in the graph.
     */
    public void notifyHidden() {
        ((PropertyNode)getFrom()).m_superPropertiesExpanded=PropertyNode.NOT_LOADED;
        ((PropertyNode)getTo()).m_subPropertiesExpanded=PropertyNode.NOT_LOADED;
    }
    /**
     * Returns the length of this edge.
     *
     * @return                      the ledge of the edge
     */
    public double getLength() {
        return m_length;
    }
    /**
     * Returns the subproperty.
     *
     * @return                      the subproperty
     */
    public Property getSubProperty() {
        return ((PropertyNode)getFrom()).getProperty();
    }
    /**
     * Returns the superproperty.
     *
     * @return                      the superproperty
     */
    public Property getSuperProperty() {
        return ((PropertyNode)getTo()).getProperty();
    }
    /**
     * Returns the property hierarchy edge between nodes.
     *
     * @param oimodelGraph          the graph
     * @param superPropertyNode     the node of the superproperty
     * @param subPropertyNode       the node of the subproperty
     * @return                      the edge (if there isn't one, <code>null</code> is returned)
     */
    public static PropertyHierarchyEdge getEdge(OIModelGraph oimodelGraph,PropertyNode superPropertyNode,PropertyNode subPropertyNode) {
        return (PropertyHierarchyEdge)oimodelGraph.getEdgeBetweenNodes(subPropertyNode,superPropertyNode);
    }
}
