package de.fzi.wim.oimodeler.oimodelgraph.graph;

import edu.unika.aifb.kaon.api.oimodel.*;

/**
 * An edge specifying the domain of a property in the model.
 */
public class PropertyDomainEdge extends OIModelEdge {
    /** The unit length of the edge. */
    public static final double UNIT_LENGTH=40.0;

    /**
     * Creates an instance of this class.
     *
     * @param propertyNode          the node for which this edge represents the domain
     * @param domainConceptNode     the domain concept of a property
     */
    public PropertyDomainEdge(PropertyNode propertyNode,ConceptNode domainConceptNode) {
        super(domainConceptNode,propertyNode);
    }
    /**
     * Notifies this edge that it has been hidden in the graph.
     */
    public void notifyHidden() {
        ((ConceptNode)getFrom()).m_propertiesFromExpanded=ConceptNode.NOT_LOADED;
        ((PropertyNode)getTo()).m_domainConceptsExpanded=PropertyNode.NOT_LOADED;
    }
    /**
     * Returns the length of this edge.
     *
     * @return                      the ledge of the edge
     */
    public double getLength() {
        return UNIT_LENGTH;
    }
    /**
     * Returns the property.
     *
     * @return                      the property
     */
    public Property getProperty() {
        return ((PropertyNode)getTo()).getProperty();
    }
    /**
     * Returns the concept.
     *
     * @return                      the concept
     */
    public Concept getConcept() {
        return ((ConceptNode)getFrom()).getConcept();
    }
    /**
     * Returns the property domain edge between nodes.
     *
     * @param oimodelGraph          the graph
     * @param propertyNode          the node for which this edge represents the domain
     * @param domainConceptNode     the domain concept of a property
     * @return                      the edge (if there isn't one, <code>null</code> is returned)
     */
    public static PropertyDomainEdge getEdge(OIModelGraph oimodelGraph,PropertyNode propertyNode,ConceptNode domainConceptNode) {
        return (PropertyDomainEdge)oimodelGraph.getEdgeBetweenNodes(domainConceptNode,propertyNode);
    }
}
