package de.fzi.wim.oimodeler.oimodelgraph.graph;

import edu.unika.aifb.kaon.api.*;

import de.fzi.wim.guibase.graphview.graph.*;

/**
 * The edge in the OI-model.
 */
public abstract class OIModelEdge extends DefaultEdge {

    /**
     * Creates an instance of this class.
     *
     * @param from                  the node from wich the edge points
     * @param to                    the node to which the edge points
     */
    public OIModelEdge(Node from,Node to) {
        super(from,to);
    }
    /**
     * Notifies the edge in the graph that it has been hidden.
     */
    public abstract void notifyHidden();
    /**
     * Hides the edge in the graph.
     *
     * @param oimodelGraph          the graph
     * @throws KAONException        thrown if there is an error
     */
    public void hideEdge(OIModelGraph oimodelGraph) throws KAONException {
        oimodelGraph.remove(this);
        notifyHidden();
    }
}
