package de.fzi.wim.oimodeler.oimodelgraph.graph;

import java.util.Random;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;

import de.fzi.wim.guibase.graphview.graph.*;

/**
 * A node representing a literal property instance value.
 */
public class LiteralPropertyInstanceValueNode extends DefaultNode {
    /** The property instance for this node. */
    protected PropertyInstance m_propertyInstance;

    /**
     * Creates a node for a property instance.
     *
     * @param propertyInstance              the property instance (must have literal value)
     * @param originalNode                  the original node (may be <code>null</code>)
     */
    public LiteralPropertyInstanceValueNode(PropertyInstance propertyInstance,Node originalNode) {
        m_propertyInstance=propertyInstance;
        if (originalNode!=null) {
            Random random=new Random();
            setLocation(originalNode.getX()+random.nextInt(60)-30,originalNode.getY()+random.nextInt(60)-30);
        }
    }
    /**
     * Returns the property instance of this node.
     *
     * @return                              the property instance of this node
     */
    public PropertyInstance getPropertyInstance() {
        return m_propertyInstance;
    }
    /**
     * Sets the new property instance.
     *
     * @param propertyInstance              the new property instance
     */
    public void setPropertyInstance(PropertyInstance propertyInstance) {
        m_propertyInstance=propertyInstance;
    }
    /**
     * Return the label of this node.
     *
     * @return                               the label of this node
     */
    public String getLabel() {
        try {
            return (String)m_propertyInstance.getTargetValue();
        }
        catch (KAONException shouldntHappen) {
            return "no-label";
        }
    }
}
