package de.fzi.wim.oimodeler.oimodelgraph.graph;

import java.util.Set;
import java.util.HashSet;
import java.util.Random;

import edu.unika.aifb.kaon.api.oimodel.*;

import de.fzi.wim.guibase.graphview.graph.*;

/**
 * A node in the OI-model graph acting as a fan-out. This node actualy manages a tree of subnodes.
 */
public class FanOutNode extends DefaultNode {
    /** The entity for which this node is the proxy. */
    protected Entity m_entity;
    /** The parent node of this node. */
    protected FanOutNode m_parentNode;
    /** The fanout nodes of this node. */
    protected Set m_children;

    /**
     * Creates a node for given entity.
     *
     * @param entity                        the entity of the node
     * @param originalNode                  the original node (may be <code>null</code>)
     * @param parentNode                    the parent node (may be <code>null</code>)
     */
    public FanOutNode(Entity entity,Node originalNode,FanOutNode parentNode) {
        m_entity=entity;
        if (originalNode!=null) {
            Random random=new Random();
            setLocation(originalNode.getX()+random.nextInt(60)-30,originalNode.getY()+random.nextInt(60)-30);
        }
        m_parentNode=parentNode;
        m_children=new HashSet();
    }
    /**
     * Returns the entity of this node.
     *
     * @return                              the entity of this node
     */
    public Entity getEntity() {
        return m_entity;
    }
    /**
     * Returns the children of this node.
     *
     * @return                              the children of this node
     */
    public Set getChildren() {
        return m_children;
    }
    /**
     * Returns the parent of this node.
     *
     * @return                              the parent of this node
     */
    public FanOutNode getParentNode() {
        return m_parentNode;
    }
    /**
     * Sets the parent node.
     *
     * @param parentNode                    the new parent of this node
     */
    public void setParentNode(FanOutNode parentNode) {
        m_parentNode=parentNode;
    }
}
