package de.fzi.wim.oimodeler.oimodelgraph.graph;

import java.util.Set;
import java.util.HashSet;
import java.util.Iterator;

import edu.unika.aifb.kaon.api.*;

import de.fzi.wim.guibase.graphview.graph.*;

/**
 * An edge for the concept instance.
 */
public class ConceptInstanceEdge extends OIModelEdge {
    /** The unit length of the edge. */
    public static final double UNIT_LENGTH=30.0;

    /**
     * Creates an instance of this class.
     *
     * @param from                  the node from wich the edge points
     * @param to                    the node to which the edge points
     */
    public ConceptInstanceEdge(Node from,Node to) {
        super(from,to);
    }
    /**
     * Notifies this edge that it has been hidden in the graph.
     */
    public void notifyHidden() {
    }
    /**
     * Hides the edge in the graph.
     *
     * @param oimodelGraph          the graph
     * @throws KAONException        thrown is there is an error
     */
    public void hideEdge(OIModelGraph oimodelGraph) throws KAONException {
        try {
            oimodelGraph.suspendEvents();
            ConceptNode conceptNode;
            if (m_to instanceof ConceptNode)
                conceptNode=(ConceptNode)m_to;
            else {
                FanOutNode fanOutNode=(FanOutNode)m_to;
                conceptNode=(ConceptNode)oimodelGraph.getNodeForEntity(fanOutNode.getEntity());
            }
            conceptNode.m_instancesExpanded=ConceptNode.NOT_LOADED;
            Set leavesToRemove=new HashSet();
            computeLeavesToRemove(m_from,leavesToRemove);
            FanOutManager fanOutManager=conceptNode.m_fanOutManager;
            Iterator iterator=leavesToRemove.iterator();
            while (iterator.hasNext()) {
                InstanceNode leaf=(InstanceNode)iterator.next();
                leaf.m_parentConceptsExpanded=InstanceNode.NOT_LOADED;
                fanOutManager.removeNode(oimodelGraph,leaf);
            }
        }
        finally {
            oimodelGraph.resumeEvents();
        }
    }
    /**
     * Computes the set of nodes to be removed.
     *
     * @param node                  the node
     * @param leavesToRemove        the set of nodes to remove
     */
    protected void computeLeavesToRemove(Node node,Set leavesToRemove) {
        if (node instanceof FanOutNode) {
            FanOutNode fanOutNode=(FanOutNode)node;
            Iterator iterator=new HashSet(fanOutNode.getChildren()).iterator();
            while (iterator.hasNext()) {
                Node child=(Node)iterator.next();
                computeLeavesToRemove(child,leavesToRemove);
            }
        }
        else
            leavesToRemove.add(node);
    }
    /**
     * Returns the length of this edge.
     *
     * @return                      the ledge of the edge
     */
    public double getLength() {
        return UNIT_LENGTH;
    }
}
