package de.fzi.wim.oimodeler.oimodelgraph.graph;

import edu.unika.aifb.kaon.api.oimodel.*;

/**
 * An edge for the concept hierarchy in the OI-model.
 */
public class ConceptHierarchyEdge extends OIModelEdge {
    /** The unit length of the edge. */
    public static final double UNIT_LENGTH=40.0;

    /** The length of the edge. */
    protected double m_length;

    /**
     * Creates an instance of this class.
     *
     * @param superConceptNode      the node of the superconcept
     * @param subConceptNode        the node of the subconcept
     * @param length                the length
     */
    public ConceptHierarchyEdge(ConceptNode superConceptNode,ConceptNode subConceptNode,double length) {
        super(subConceptNode,superConceptNode);
        m_length=length;
    }
    /**
     * Hides the edge in the graph.
     */
    public void notifyHidden() {
        ((ConceptNode)getFrom()).m_superConceptsExpanded=ConceptNode.NOT_LOADED;
        ((ConceptNode)getTo()).m_subConceptsExpanded=ConceptNode.NOT_LOADED;

    }
    /**
     * Returns the length of this edge.
     *
     * @return                      the ledge of the edge
     */
    public double getLength() {
        return m_length;
    }
    /**
     * Returns the subconcept.
     *
     * @return                      the subconcept
     */
    public Concept getSubConcept() {
        return ((ConceptNode)getFrom()).getConcept();
    }
    /**
     * Returns the superconcept.
     *
     * @return                      the superconcept
     */
    public Concept getSuperConcept() {
        return ((ConceptNode)getTo()).getConcept();
    }
    /**
     * Returns the concept hierarchy edge between nodes.
     *
     * @param oimodelGraph          the graph
     * @param superConceptNode      the node of the superconcept
     * @param subConceptNode        the node of the subconcept
     * @return                      the edge (if there isn't one, <code>null</code> is returned)
     */
    public static ConceptHierarchyEdge getEdge(OIModelGraph oimodelGraph,ConceptNode superConceptNode,ConceptNode subConceptNode) {
        return (ConceptHierarchyEdge)oimodelGraph.getEdgeBetweenNodes(subConceptNode,superConceptNode);
    }
}
