package de.fzi.wim.oimodeler.oimodelgraph.controller;

import java.util.Map;
import java.util.HashMap;
import java.util.Set;
import java.util.HashSet;
import java.util.Iterator;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.JMenuItem;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;

import de.fzi.wim.guibase.graphview.graph.*;
import de.fzi.wim.guibase.graphview.view.*;

import de.fzi.wim.oimodeler.oimodelgraph.*;
import de.fzi.wim.oimodeler.oimodelgraph.graph.*;
import de.fzi.wim.oimodeler.oimodelgraph.view.*;

/**
 * A manipulator that can expand different types of nodes.
 */
public class NodeExpansionManipulator extends AbstractManipulator {
    /** The name of this manipulator. */
    public static final String NAME="NodeExpansionManipulator";

    /** The OI-model graph anchor. */
    protected OIModelGraphAnchor m_oimodelGraphAnchor;

    /**
     * Creates an instance of this class.
     *
     * @param oimodelGraphAnchor            the graph anchor
     */
    public NodeExpansionManipulator(OIModelGraphAnchor oimodelGraphAnchor) {
        m_oimodelGraphAnchor=oimodelGraphAnchor;
    }
    public String getName() {
        return NAME;
    }
    public void mousePressed(MouseEvent e) {
        if (m_graphPane.isEnabled() && (e.getModifiers() & MouseEvent.BUTTON1_MASK)!=0 && (e.getModifiers() & MouseEvent.SHIFT_MASK)==0)
            try {
                OIModelGraph oimodelGraph=(OIModelGraph)m_graphPane.getGraph();
                Point point=e.getPoint();
                Node node=m_graphPane.getNodeAtPoint(point);
                if (node instanceof ConceptNode) {
                    ConceptNode conceptNode=(ConceptNode)node;
                    ConceptNodePainter conceptNodePainter=(ConceptNodePainter)m_graphPane.getPainterForNode(conceptNode);
                    conceptNodePainter.loadNodeGeometry(m_graphPane,conceptNode);
                    if (conceptNode.getSubConceptsExpanded()==ConceptNode.NOT_LOADED && conceptNodePainter.m_handles[ConceptNodePainter.SUBCONCEPTS_HANDLE].contains(point)) {
                        conceptNode.expandSubConcepts(oimodelGraph);
                        m_graphPane.repaintNode(conceptNode);
                        e.consume();
                    }
                    else if (conceptNode.getSuperConceptsExpanded()==ConceptNode.NOT_LOADED && conceptNodePainter.m_handles[ConceptNodePainter.SUPERCONCEPTS_HANDLE].contains(point)) {
                        conceptNode.expandSuperConcepts(oimodelGraph);
                        m_graphPane.repaintNode(conceptNode);
                        e.consume();
                    }
                    else if (conceptNode.getPropertiesFromExpanded()==ConceptNode.NOT_LOADED && conceptNodePainter.m_handles[ConceptNodePainter.PROPERTIES_FROM_HANDLE].contains(point)) {
                        conceptNode.expandPropertiesFrom(oimodelGraph);
                        m_graphPane.repaintNode(conceptNode);
                        e.consume();
                    }
                    else if (conceptNode.getPropertiesToExpanded()==ConceptNode.NOT_LOADED && conceptNodePainter.m_handles[ConceptNodePainter.PROPERTIES_TO_HANDLE].contains(point)) {
                        conceptNode.expandPropertiesTo(oimodelGraph);
                        m_graphPane.repaintNode(conceptNode);
                        e.consume();
                    }
                    else if (conceptNode.getInstancesExpanded()==ConceptNode.NOT_LOADED && conceptNodePainter.m_handles[ConceptNodePainter.INSTANCES_HANDLE].contains(point)) {
                        conceptNode.expandInstances(oimodelGraph);
                        m_graphPane.repaintNode(conceptNode);
                        e.consume();
                    }
                    else if (conceptNode.getSpanningObjectsExpanded()==ConceptNode.NOT_LOADED && conceptNodePainter.m_handles[ConceptNodePainter.SPANNING_OBJECTS_HANDLE].contains(point)) {
                        conceptNode.expandSpanningObjects(oimodelGraph);
                        m_graphPane.repaintNode(conceptNode);
                        e.consume();
                    }
                }
                else if (node instanceof PropertyNode) {
                    PropertyNode propertyNode=(PropertyNode)node;
                    PropertyNodePainter propertyNodePainter=(PropertyNodePainter)m_graphPane.getPainterForNode(propertyNode);
                    propertyNodePainter.loadNodeGeometry(m_graphPane,propertyNode);
                    if (propertyNode.getSubPropertiesExpanded()==PropertyNode.NOT_LOADED && propertyNodePainter.m_handles[PropertyNodePainter.SUBPROPERTIES_HANDLE].contains(point)) {
                        propertyNode.expandSubProperties(oimodelGraph);
                        m_graphPane.repaintNode(propertyNode);
                        e.consume();
                    }
                    else if (propertyNode.getSuperPropertiesExpanded()==PropertyNode.NOT_LOADED && propertyNodePainter.m_handles[PropertyNodePainter.SUPERPROPERTIES_HANDLE].contains(point)) {
                        propertyNode.expandSuperProperties(oimodelGraph);
                        m_graphPane.repaintNode(propertyNode);
                        e.consume();
                    }
                    else if (propertyNode.getDomainConceptsExpanded()==PropertyNode.NOT_LOADED && propertyNodePainter.m_handles[PropertyNodePainter.DOMAIN_CONCEPTS_HANDLE].contains(point)) {
                        propertyNode.expandDomainConcepts(oimodelGraph);
                        m_graphPane.repaintNode(propertyNode);
                        e.consume();
                    }
                    else if (propertyNode.getRangeConceptsExpanded()==PropertyNode.NOT_LOADED && propertyNodePainter.m_handles[PropertyNodePainter.RANGE_CONCEPTS_HANDLE].contains(point)) {
                        propertyNode.expandRangeConcepts(oimodelGraph);
                        m_graphPane.repaintNode(propertyNode);
                        e.consume();
                    }
                    else if (propertyNode.getSpanningObjectsExpanded()==PropertyNode.NOT_LOADED && propertyNodePainter.m_handles[PropertyNodePainter.SPANNING_OBJECTS_HANDLE].contains(point)) {
                        propertyNode.expandSpanningObjects(oimodelGraph);
                        m_graphPane.repaintNode(propertyNode);
                        e.consume();
                    }
                }
                else if (node instanceof InstanceNode) {
                    final InstanceNode instanceNode=(InstanceNode)node;
                    InstanceNodePainter instanceNodePainter=(InstanceNodePainter)m_graphPane.getPainterForNode(instanceNode);
                    instanceNodePainter.loadNodeGeometry(m_graphPane,instanceNode);
                    if (instanceNode.getParentConceptsExpanded()==InstanceNode.NOT_LOADED && instanceNodePainter.m_handles[InstanceNodePainter.PARENT_CONCEPTS_HANDLE].contains(point)) {
                        instanceNode.expandParentConcepts(oimodelGraph);
                        m_graphPane.repaintNode(instanceNode);
                        e.consume();
                    }
                    else if (instanceNode.getPropertyInstancesToExpanded()==InstanceNode.NOT_LOADED && instanceNodePainter.m_handles[InstanceNodePainter.PROPERTY_INSTANCES_TO_HANDLE].contains(point)) {
                        instanceNode.expandPropertyInstancesTo(oimodelGraph,new ShowMenuCompletion(instanceNode,e,false));
                        e.consume();
                    }
                    else if (instanceNode.getPropertyInstancesFromExpanded()==InstanceNode.NOT_LOADED && instanceNodePainter.m_handles[InstanceNodePainter.PROPERTY_INSTANCES_FROM_HANDLE].contains(point)) {
                        instanceNode.expandPropertyInstancesFrom(oimodelGraph,new ShowMenuCompletion(instanceNode,e,true));
                        e.consume();
                    }
                    else if (instanceNode.getSpanningObjectsExpanded()==InstanceNode.NOT_LOADED && instanceNodePainter.m_handles[InstanceNodePainter.SPANNING_OBJECTS_HANDLE].contains(point)) {
                        instanceNode.expandSpanningObjects(oimodelGraph);
                        m_graphPane.repaintNode(instanceNode);
                        e.consume();
                    }
                }
            }
            catch (KAONException error) {
                e.consume();
                m_oimodelGraphAnchor.notifyError(error);
            }
    }

    /**
     * The property instance loading completion that shows a menu.
     */
    protected class ShowMenuCompletion implements InstanceNode.PropertyInstanceLoadingCompletion {
        protected InstanceNode m_instanceNode;
        protected MouseEvent m_event;
        protected boolean m_expandPropertiesFrom;

        public ShowMenuCompletion(InstanceNode instanceNode,MouseEvent event,boolean expandPropertiesFrom) {
            m_instanceNode=instanceNode;
            m_event=event;
            m_expandPropertiesFrom=expandPropertiesFrom;
        }
        public void propertyInstancesLoaded(final Set propertyInstances) {
            try {
                JPopupMenu menu=new JPopupMenu();
                JMenuItem item=menu.add(m_oimodelGraphAnchor.getLocalizationManager().getPhrase("oimodeler.oimodelgraph.properties.all"));
                item.addActionListener(new ActionListener() {
                    public void actionPerformed(ActionEvent evt) {
                        try {
                            if (m_expandPropertiesFrom) {
                                m_instanceNode.expandPropertyInstancesFrom((OIModelGraph)m_graphPane.getGraph(),propertyInstances);
                                m_instanceNode.notifyAllPropertyInstancesFromExpanded((OIModelGraph)m_graphPane.getGraph());
                            }
                            else {
                                m_instanceNode.expandPropertyInstancesTo((OIModelGraph)m_graphPane.getGraph(),propertyInstances);
                                m_instanceNode.notifyAllPropertyInstancesToExpanded((OIModelGraph)m_graphPane.getGraph());
                            }
                        }
                        catch (KAONException error) {
                            m_oimodelGraphAnchor.notifyError(error);
                        }
                    }
                });
                if (m_expandPropertiesFrom) {
                    item=menu.add(m_oimodelGraphAnchor.getLocalizationManager().getPhrase("oimodeler.oimodelgraph.properties.allAttributes"));
                    item.addActionListener(new ActionListener() {
                        public void actionPerformed(ActionEvent evt) {
                            try {
                                Set attributePropertyInstances=new HashSet();
                                Iterator iterator=propertyInstances.iterator();
                                while (iterator.hasNext()) {
                                    PropertyInstance propertyInstance=(PropertyInstance)iterator.next();
                                    if (!(propertyInstance.getTargetValue() instanceof Instance))
                                        attributePropertyInstances.add(propertyInstance);
                                }
                                m_instanceNode.expandPropertyInstancesFrom((OIModelGraph)m_graphPane.getGraph(),attributePropertyInstances);
                            }
                            catch (KAONException error) {
                                m_oimodelGraphAnchor.notifyError(error);
                            }
                        }
                    });
                }
                else {
                    item=menu.add(m_oimodelGraphAnchor.getLocalizationManager().getPhrase("oimodeler.oimodelgraph.properties.allButLexical"));
                    item.addActionListener(new ActionListener() {
                        public void actionPerformed(ActionEvent evt) {
                            try {
                                Set nonLexicalPropertyInstances=new HashSet();
                                Iterator iterator=propertyInstances.iterator();
                                while (iterator.hasNext()) {
                                    PropertyInstance propertyInstance=(PropertyInstance)iterator.next();
                                    if (!propertyInstance.getProperty().getURI().startsWith(KAONConnection.LEXICAL_OIMODEL_URI))
                                        nonLexicalPropertyInstances.add(propertyInstance);
                                }
                                m_instanceNode.expandPropertyInstancesTo((OIModelGraph)m_graphPane.getGraph(),nonLexicalPropertyInstances);
                            }
                            catch (KAONException error) {
                                m_oimodelGraphAnchor.notifyError(error);
                            }
                        }
                    });
                }
                Map propertyInstancesMap=new HashMap();
                Iterator elements=propertyInstances.iterator();
                while (elements.hasNext()) {
                    PropertyInstance propertyInstance=(PropertyInstance)elements.next();
                    Property property=propertyInstance.getProperty();
                    if (m_oimodelGraphAnchor.getViewFilter().showEntity(property)) {
                        Set instancesForProperty=(Set)propertyInstancesMap.get(property);
                        if (instancesForProperty==null) {
                            instancesForProperty=new HashSet();
                            propertyInstancesMap.put(property,instancesForProperty);
                        }
                        instancesForProperty.add(propertyInstance);
                    }
                }
                if (!propertyInstancesMap.isEmpty()) {
                    menu.addSeparator();
                    elements=propertyInstancesMap.keySet().iterator();
                    while (elements.hasNext()) {
                        Property property=(Property)elements.next();
                        final Set instancesForProperty=(Set)propertyInstancesMap.get(property);
                        item=menu.add(getLabel(property));
                        item.addActionListener(new ActionListener() {
                            public void actionPerformed(ActionEvent evt) {
                                try {
                                    if (m_expandPropertiesFrom)
                                        m_instanceNode.expandPropertyInstancesFrom((OIModelGraph)m_graphPane.getGraph(),instancesForProperty);
                                    else
                                        m_instanceNode.expandPropertyInstancesTo((OIModelGraph)m_graphPane.getGraph(),instancesForProperty);
                                }
                                catch (KAONException error) {
                                    m_oimodelGraphAnchor.notifyError(error);
                                }
                            }
                        });
                    }
                }
                menu.show(m_event.getComponent(),m_event.getX(),m_event.getY());
            }
            catch (KAONException error) {
                m_oimodelGraphAnchor.notifyError(error);
            }
        }
        public String getLabel(Entity entity) throws KAONException {
            String label=entity.getLabel(m_oimodelGraphAnchor.getLanguageURI());
            if (label==null)
                label=m_oimodelGraphAnchor.replaceURIPrefix(entity.getURI());
            return label;
        }
    }
}
