package de.fzi.wim.oimodeler.oimodelgraph.controller;

import java.util.Set;
import java.util.List;
import java.util.LinkedList;
import java.util.Iterator;
import java.util.Collections;
import java.awt.Point;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.KeyEvent;
import java.awt.event.ActionEvent;
import javax.swing.JPopupMenu;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.api.change.*;
import edu.unika.aifb.kaon.api.util.*;

import de.fzi.wim.guibase.graphview.graph.*;
import de.fzi.wim.guibase.graphview.view.*;
import de.fzi.wim.guibase.actions.*;

import de.fzi.wim.oimodeler.oimodelgraph.*;
import de.fzi.wim.oimodeler.oimodelgraph.graph.*;

/**
 * A manipulator allowing connection of nodes.
 */
public class ConnectionManipulator extends AbstractManipulator {
    /** The name of this manipulator. */
    public static final String NAME="ConnectionManipulator";

    /** The OI-model graph anchor. */
    protected OIModelGraphAnchor m_oimodelGraphAnchor;
    /** The node from which the line is dragged. */
    protected Node m_sourceNode;
    /** The point from which the line is drawn. */
    protected Point m_sourcePoint;
    /** The point to which the line is drawn. */
    protected Point m_targetPoint;

    /**
     * Creates an instance of this class.
     *
     * @param oimodelGraphAnchor                the OI-model graph anchor
     */
    public ConnectionManipulator(OIModelGraphAnchor oimodelGraphAnchor) {
        m_oimodelGraphAnchor=oimodelGraphAnchor;
    }
    public String getName() {
        return NAME;
    }
    public void paint(Graphics2D g) {
        if (m_sourceNode!=null)
            g.drawLine(m_sourcePoint.x,m_sourcePoint.y,m_targetPoint.x,m_targetPoint.y);
    }
    public void mousePressed(MouseEvent e) {
        if (m_graphPane.isEnabled() && (e.getModifiers() & MouseEvent.BUTTON1_MASK)!=0 && isStartConnectionEvent(e)) {
            Point point=e.getPoint();
            m_sourceNode=m_graphPane.getNodeAtPoint(point);
            if ((m_sourceNode instanceof ConceptNode) || (m_sourceNode instanceof PropertyNode) || (m_sourceNode instanceof InstanceNode) || (m_sourceNode instanceof PropertyInstancesNode)) {
                updateLastMouseEventScreenPoint(e);
                m_sourcePoint=m_graphPane.getScreenPointForNode(m_sourceNode);
                m_targetPoint=point;
                m_graphPane.repaint();
                e.consume();
            }
            else
                m_sourceNode=null;
        }
    }
    public void mouseReleased(MouseEvent e) {
        if (m_sourceNode!=null) {
            Node sourceNode=m_sourceNode;
            Node targetNode=m_graphPane.getNodeAtPoint(e.getPoint());
            m_sourceNode=null;
            m_sourcePoint=null;
            m_targetPoint=null;
            m_lastMouseEventScreenPoint=null;
            m_graphPane.repaint();
            e.consume();
            if (targetNode!=null && targetNode!=sourceNode)
                createLink(sourceNode,targetNode,e);
        }
    }
    public void mouseDragged(MouseEvent e) {
        if (m_sourceNode!=null) {
            autoscroll(e);
            updateLastMouseEventScreenPoint(e);
            m_targetPoint=e.getPoint();
            m_graphPane.repaint();
        }
    }
    public void keyTyped(KeyEvent e) {
        if (m_sourceNode!=null && e.getKeyChar()==KeyEvent.VK_ESCAPE) {
            m_sourceNode=null;
            m_sourcePoint=null;
            m_targetPoint=null;
            m_lastMouseEventScreenPoint=null;
            m_graphPane.repaint();
        }
    }
    public void notifyGraphPaneScrolled() {
        if (m_sourceNode!=null) {
            m_sourcePoint=m_graphPane.getScreenPointForNode(m_sourceNode);
            m_targetPoint=getLastMouseEventPoint();
            m_graphPane.repaint();
        }
    }
    protected boolean isStartConnectionEvent(MouseEvent e) {
        return (e.getModifiers() & MouseEvent.SHIFT_MASK)==0;
    }
    /**
     * Creates a link between nodes.
     *
     * @param sourceNode                    the node from which the link is created
     * @param targetNode                    the node to which the link is created
     * @param event                         the original event
     */
    protected void createLink(Node sourceNode,Node targetNode,MouseEvent event) {
        try {
            List events=new LinkedList();
            if ((sourceNode instanceof ConceptNode) && (targetNode instanceof ConceptNode))
                events.add(new AddSubConcept(m_oimodelGraphAnchor.getActiveOIModel(),null,((ConceptNode)targetNode).getConcept(),((ConceptNode)sourceNode).getConcept()));
            else if ((sourceNode instanceof ConceptNode) && (targetNode instanceof PropertyNode))
                events.add(new AddPropertyDomain(m_oimodelGraphAnchor.getActiveOIModel(),null,((PropertyNode)targetNode).getProperty(),((ConceptNode)sourceNode).getConcept()));
            else if ((sourceNode instanceof PropertyNode) && (targetNode instanceof ConceptNode))
                events.add(new AddPropertyRange(m_oimodelGraphAnchor.getActiveOIModel(),null,((PropertyNode)sourceNode).getProperty(),((ConceptNode)targetNode).getConcept()));
            else if ((sourceNode instanceof PropertyNode) && (targetNode instanceof PropertyNode))
                events.add(new AddSubProperty(m_oimodelGraphAnchor.getActiveOIModel(),null,((PropertyNode)targetNode).getProperty(),((PropertyNode)sourceNode).getProperty()));
            else if ((sourceNode instanceof InstanceNode) && (targetNode instanceof ConceptNode))
                events.add(new AddInstanceOf(m_oimodelGraphAnchor.getActiveOIModel(),null,((ConceptNode)targetNode).getConcept(),((InstanceNode)sourceNode).getInstance()));
            else if ((sourceNode instanceof InstanceNode) && (targetNode instanceof PropertyNode)) {
                String value=m_oimodelGraphAnchor.getLocalizationManager().getPhrase("oimodeler.newAttributeValue");
                events.add(new AddPropertyInstance(m_oimodelGraphAnchor.getActiveOIModel(),null,((PropertyNode)targetNode).getProperty(),((InstanceNode)sourceNode).getInstance(),value));
            }
            else if ((sourceNode instanceof InstanceNode) && (targetNode instanceof InstanceNode)) {
                final Instance sourceInstance=((InstanceNode)sourceNode).getInstance();
                Instance targetInstance=((InstanceNode)targetNode).getInstance();
                Set allowedProperties=PropertyInstanceUtil.getAllowedProperties(sourceInstance,Collections.singleton(targetInstance));
                if (!allowedProperties.isEmpty()) {
                    JPopupMenu popupMenu=new JPopupMenu();
                    Iterator iterator=allowedProperties.iterator();
                    while (iterator.hasNext()) {
                        Property property=(Property)iterator.next();
                        popupMenu.add(new AddRelationInstance(property,sourceInstance,targetInstance));
                    }
                    popupMenu.show(m_graphPane,event.getX(),event.getY());
                }
            }
            else if ((sourceNode instanceof PropertyInstancesNode) && (targetNode instanceof InstanceNode))
                events.add(new AddPropertyInstance(m_oimodelGraphAnchor.getActiveOIModel(),null,((PropertyInstancesNode)sourceNode).getProperty(),((PropertyInstancesNode)sourceNode).getSourceInstance(),((InstanceNode)targetNode).getInstance()));
            if (!events.isEmpty())
                m_oimodelGraphAnchor.changeOIModel(events);
        }
        catch (KAONException ignored) {
        }
    }

    /**
     * The action for adding a relation instance between instances.
     */
    protected class AddRelationInstance extends AbstractSmartAction {
        protected Instance m_sourceInstance;
        protected Instance m_targetInstance;
        protected Property m_property;

        public AddRelationInstance(Property property,Instance sourceInstance,Instance targetInstance) throws KAONException {
            super("");
            m_property=property;
            m_sourceInstance=sourceInstance;
            m_targetInstance=targetInstance;
            String label=m_property.getLabel(m_oimodelGraphAnchor.getLanguageURI());
            if (label==null)
                label=m_property.getURI();
            setName(label);
        }
        public void actionPerformed(ActionEvent e) {
            try {
                m_oimodelGraphAnchor.changeOIModel(Collections.singletonList(new AddPropertyInstance(m_oimodelGraphAnchor.getActiveOIModel(),null,m_property,m_sourceInstance,m_targetInstance)));
            }
            catch (KAONException error) {
                m_oimodelGraphAnchor.notifyError(error);
            }
        }
    }
}
