package de.fzi.wim.oimodeler.oimodelgraph.controller;

import java.util.List;
import java.util.LinkedList;
import java.util.Collections;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.api.change.*;
import edu.unika.aifb.kaon.api.vocabulary.*;
import edu.unika.aifb.kaon.api.util.*;

import de.fzi.wim.guibase.graphview.graph.*;
import de.fzi.wim.guibase.graphview.view.*;
import de.fzi.wim.guibase.graphview.inplaceedit.*;

import de.fzi.wim.oimodeler.ui.*;
import de.fzi.wim.oimodeler.oimodelgraph.*;
import de.fzi.wim.oimodeler.oimodelgraph.graph.*;
import de.fzi.wim.oimodeler.oimodelgraph.view.*;

/**
 * A manipulator for editing attributes.
 */
public class AttributeEditorManipulator extends AbstractManipulator {
    /** The name of this manipulator. */
    public static final String NAME="AttributeEditorManipulator";

    /** The OI-model graph anchor. */
    protected OIModelGraphAnchor m_oimodelGraphAnchor;

    /**
     * Creates an instance of this class.
     *
     * @param oimodelGraphAnchor                the graph anchor
     */
    public AttributeEditorManipulator(OIModelGraphAnchor oimodelGraphAnchor) {
        m_oimodelGraphAnchor=oimodelGraphAnchor;
    }
    public String getName() {
        return NAME;
    }
    public void mousePressed(MouseEvent e) {
        if (m_graphPane.isEnabled() && (e.getModifiers() & MouseEvent.BUTTON1_MASK)!=0 && e.getClickCount()>=2) {
            Point point=e.getPoint();
            Node node=m_graphPane.getNodeAtPoint(point);
            if (node instanceof LiteralPropertyInstanceValueNode) {
                EditorTextFieldInPlaceNodeEditor editor=new EditorTextFieldInPlaceNodeEditor(m_graphPane,node,new LiteralValueEditingController());
                editor.startEditing();
            }
            else if (node instanceof EntityNode) {
                EditorTextFieldInPlaceNodeEditor editor=new EditorTextFieldInPlaceNodeEditor(m_graphPane,node,new LabelEditingController()) {
                    protected JComponent createEditorComponent() {
                        JComponent component=super.createEditorComponent();
                        component.setBorder(BorderFactory.createEmptyBorder());
                        return component;
                    }
                };
                editor.startEditing();
            }
        }
    }

    /**
     * Literal value in-place editing conroller.
     */
    protected class LiteralValueEditingController implements NodeEditingController {
        public Object editingStarted(Node node) {
            try {
                LiteralPropertyInstanceValueNode literalPropertyInstanceValueNode=(LiteralPropertyInstanceValueNode)node;
                return literalPropertyInstanceValueNode.getPropertyInstance().getTargetValue();
            }
            catch (KAONException ignored) {
                return null;
            }
        }
        public boolean editingFinished(Node node,Object value) {
            try {
                LiteralPropertyInstanceValueNode literalPropertyInstanceValueNode=(LiteralPropertyInstanceValueNode)node;
                PropertyInstance propertyInstance=literalPropertyInstanceValueNode.getPropertyInstance();
                m_oimodelGraphAnchor.changeOIModel(Collections.singletonList(new ChangePropertyInstanceValue(propertyInstance.getSourceOIModel(),null,propertyInstance,value)));
                return true;
            }
            catch (KAONException error) {
                m_oimodelGraphAnchor.notifyError(error);
                return false;
            }
        }
        public void editingAborted(Node node) {
        }
    }

    /**
     * Label in-place editing conroller.
     */
    protected class LabelEditingController implements NodeEditingController {
        public Object editingStarted(Node node) {
            return node.getLabel();
        }
        public boolean editingFinished(Node node,Object value) {
            try {
                List events=new LinkedList();
                Entity entity=((EntityNode)node).getEntity();
                OIModel oimodel=entity.getOIModel();
                LexicalEntry labelEntry=entity.getLexicalEntry(KAONVocabularyAdaptor.INSTANCE.getKAONLabel(),m_oimodelGraphAnchor.getLanguageURI());
                if (labelEntry==null) {
                    labelEntry=oimodel.getLexicalEntry(oimodel.createNewURI());
                    LexiconUtil.createLexicalEntry(labelEntry,KAONVocabularyAdaptor.INSTANCE.getKAONLabel(),value.toString(),m_oimodelGraphAnchor.getLanguageURI(),entity,events);
                }
                else {
                    Object existingValue=labelEntry.getAttribute(KAONVocabularyAdaptor.INSTANCE.getValue());
                    Property valueProperty=oimodel.getProperty(KAONVocabularyAdaptor.INSTANCE.getValue());
                    if (existingValue==null)
                        events.add(new AddPropertyInstance(m_oimodelGraphAnchor.getActiveOIModel(),null,valueProperty,labelEntry,value));
                    else {
                        PropertyInstance propertyInstance=m_oimodelGraphAnchor.getOIModel().getPropertyInstance(valueProperty,labelEntry,existingValue);
                        events.add(new ChangePropertyInstanceValue(propertyInstance.getSourceOIModel(),null,propertyInstance,value));
                    }
                }
                m_oimodelGraphAnchor.changeOIModel(events);
            }
            catch (KAONException error) {
                m_oimodelGraphAnchor.notifyError(error);
            }
            return true;
        }
        public void editingAborted(Node node) {
        }
    }

    /**
     * The editor for the text.
     */
    protected class EditorTextFieldInPlaceNodeEditor extends TextFieldInPlaceNodeEditor {

        public EditorTextFieldInPlaceNodeEditor(JGraphPane graphPane,Node node,NodeEditingController nodeEditingController) {
            super(graphPane,node,nodeEditingController);
        }
        protected void setEditorComponentValue(JComponent component,Object value) {
            OIModelerViewable.setFont(m_oimodelGraphAnchor.getLanguageURI(),m_component);
            super.setEditorComponentValue(component,value);
        }
        protected void updatePosition() {
            if (m_node instanceof EntityNode) {
                EntityNodePainter painter=(EntityNodePainter)m_graphPane.getPainterForNode(m_node);
                painter.loadNodeGeometry(m_graphPane,m_node);
                Rectangle nodeLabel=painter.m_nodeLabel;
                int preferredHeight=m_component.getPreferredSize().height;
                m_component.setLocation(nodeLabel.x+1,nodeLabel.y+(nodeLabel.height-preferredHeight)/2);
                m_component.setSize(nodeLabel.width-2,preferredHeight);
            }
            else
                super.updatePosition();
        }
    }
}
