package de.fzi.wim.oimodeler.oimodelgraph;

import java.util.List;

import edu.unika.aifb.kaon.api.oimodel.*;

import de.fzi.wim.guibase.localization.*;
import de.fzi.wim.guibase.util.*;

import de.fzi.wim.oimodeler.viewfilter.*;

/**
 * This anchor is a container for the OI-model graph components and provides common environment services.
 * A component that wants to reuse the OI-model graph should implement this interface.
 */
public interface OIModelGraphAnchor {
    /**
     * Returns the localization manager.
     *
     * @return                              the localization manager
     */
    LocalizationManager getLocalizationManager();
    /**
     * Notifies the anchor that an error has happened.
     *
     * @param throwable                     contains information about the error
     */
    void notifyError(Throwable throwable);
    /**
     * Returns the URI of the language that is shown in the.
     *
     * @return                              the URI of the language
     */
    String getLanguageURI();
    /**
     * Applies the changes to the OI-model.
     *
     * @param changeEvents                  the list of changes
     */
    void changeOIModel(List changeEvents);
    /**
     * Returns the outer OI-model.
     *
     * @return                              the OI-model
     */
    OIModel getOIModel();
    /**
     * Returns the active OI-model.
     *
     * @return                              the active OI-model
     */
    OIModel getActiveOIModel();
    /**
     * Returns the thread pool.
     *
     * @return                              the thread pool
     */
    ThreadPool getThreadPool();
    /**
     * Returns the view filter.
     *
     * @return                              the view filter
     */
    ViewFilter getViewFilter();
    /**
     * Possibly replaces the namespace prefix within the URI.
     *
     * @param uri                       the URI
     * @return                          the URI with possibly replaced namespace
     */
    String replaceURIPrefix(String uri);
}
