package de.fzi.wim.oimodeler.lexicon;

import java.awt.Component;
import java.awt.im.InputContext;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.table.JTableHeader;

import de.fzi.wim.guibase.menus.JTablePopupMenuManipulator;
import de.fzi.wim.guibase.selectionsource.AbstractJTableSelectionSource;
import de.fzi.wim.guibase.tables.SmartCellEditor;
import de.fzi.wim.guibase.tables.SortableTableHeader;
import de.fzi.wim.oimodeler.inspector.EntityInfoPage;
import de.fzi.wim.oimodeler.ui.OIModelerViewable;
import edu.unika.aifb.kaon.api.oimodel.Entity;
import edu.unika.aifb.kaon.api.oimodel.LexicalEntry;

/**
 * The lexical table.
 */
public class LexiconTable extends AbstractJTableSelectionSource implements EntityInfoPage {
    /** The input context for the editor. */
    protected InputContext m_editorInputContext;

    /**
     * Creates an instance of this class.
     *
     * @param oimodelerViewable                 the viewable
     */
    public LexiconTable(OIModelerViewable oimodelerViewable) {
        super(oimodelerViewable.getOIModelerSelectionSourceManager(),createLexiconTableModel(oimodelerViewable));
        m_editorInputContext=InputContext.getInstance();
        new JTablePopupMenuManipulator(this,oimodelerViewable.getModule().getAppDriver().createPopupMenu("popup.oimodeler.lexiconSelection"));
        LexiconTableModel model=(LexiconTableModel)getModel();
        getColumnModel().getColumn(2).setCellRenderer(new LexiconValueRenderer());
        getColumnModel().getColumn(0).setCellEditor(new ComboBoxChooser(model.getTypeURIsNames().values()));
        getColumnModel().getColumn(1).setCellEditor(new ComboBoxChooser(model.getLanguageURIsNames().values()));
        getColumnModel().getColumn(2).setCellEditor(new LexiconValueEditor(new JTextField() {
            public InputContext getInputContext() {
                return m_editorInputContext;
            }
        }));
        setRowHeight(20);
        addToolTipRenderers();
    }
    /**
     * Updates the UI.
     */
    public void updateUI() {
        super.updateUI();
        Component parent=getParent();
        if (parent instanceof JViewport)
            parent.setBackground(getBackground());
    }
    /**
     * Overridden to set the color of the enclosing viewport.
     */
    protected void configureEnclosingScrollPane() {
        super.configureEnclosingScrollPane();
        Component parent=getParent();
        if (parent instanceof JViewport)
            parent.setBackground(getBackground());
    }
    /**
     * Creates the default table header.
     *
     * @return                                  the default table header
     */
    protected JTableHeader createDefaultTableHeader() {
        final SortableTableHeader header=new SortableTableHeader(columnModel);
        header.addPropertyChangeListener(new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                if (SortableTableHeader.SORTED_COLUMN_PROPERTY.equals(evt.getPropertyName()) || SortableTableHeader.SORT_ASCENDING_PROPERTY.equals(evt.getPropertyName())) {
                    ((LexiconTableModel)getModel()).sortModel(header.getSortedColumn().getModelIndex(),header.getSortAscending());
                }
            }
        });
        return header;
    }
    /**
     * Disposes of this table.
     */
    public void dispose() {
        if (isEditing())
            getCellEditor().cancelCellEditing();
        ((LexiconTableModel)getModel()).dispose();
        if (m_editorInputContext!=null) {
            m_editorInputContext.dispose();
            m_editorInputContext=null;
        }
    }
    /**
     * Sets the entity whose lexicon is displayed.
     *
     * @param entity                            the entity
     */
    public void showEntity(Entity entity) {
        ((LexiconTableModel)getModel()).showEntity(entity);
    }
    /**
     * Displays an empty model.
     */
    public void showNothing() {
        ((LexiconTableModel)getModel()).showNothing();
    }
    /**
     * Returns the current entity.
     *
     * @return                      the entity shown
     */
    public Entity getCurrentEntity() {
        return ((LexiconTableModel)getModel()).getShownEntity();
    }
    /**
     * Updates the sorting of the table.
     */
    protected void updateSorting() {
    }
    /**
     * Sets the language URI.
     *
     * @param languageURI           the language URI
     */
    public void setLanguageURI(String languageURI) {
    }
    /**
     * Returns the current selection.
     *
     * @return                                  the collection of selected entities
     */
    public Collection getSelection() {
        LexiconTableModel model=(LexiconTableModel)getModel();
        Entity referencedEntity=model.getShownEntity();
        int[] selectedRows=getSelectedRows();
        Collection selection=new HashSet();
        for (int i=0;i<selectedRows.length;i++)
            if (selectedRows[i]<model.getRowCount()-1) {
                LexiconTableModel.TableRow tableRow=model.getTableData(selectedRows[i]);
                selection.add(new LexiconSelection(tableRow.m_lexicalEntry,referencedEntity,tableRow.m_value));
            }
        return selection;
    }
    /**
     * Creates the table model using the factory.
     *
     * @param oimodelerViewable                 the viewable
     * @return                                  lexicon table model
     */
    protected static LexiconTableModel createLexiconTableModel(OIModelerViewable oimodelerViewable) {
        try {
            return (LexiconTableModel)oimodelerViewable.getModule().getAppDriver().getClassFactory().createElement("de.fzi.wim.oimodeler.lexicon.LexiconTableModel",new Object[] { oimodelerViewable });
        }
        catch (Exception error) {
            throw new RuntimeException("Internal error: cannot create LexiconTableModel.",error);
        }
    }

    /**
     * The renderer for the lexicon value.
     */
    protected static class LexiconValueRenderer extends ToolTipCellRenderer {
        public Component getTableCellRendererComponent(JTable table,Object value,boolean isSelected,boolean hasFocus,int row,int column) {
            super.getTableCellRendererComponent(table,value,isSelected,hasFocus,row,column);
            LexiconTableModel model=(LexiconTableModel)table.getModel();
            String languageURI;
            if (row+1==model.getRowCount())
                languageURI=model.getNewItemLanguageURI();
            else
                languageURI=model.getTableData(row).m_languageURI;
            OIModelerViewable.setFont(languageURI,this);
            return this;
        }
    }

    /**
     * The editor for the lexicon value.
     */
    protected static class LexiconValueEditor extends SmartCellEditor {
        public LexiconValueEditor(JTextField textField) {
            super(textField);
        }
        public Component getTableCellEditorComponent(JTable table,Object value,boolean isSelected,int row,int column) {
            super.getTableCellEditorComponent(table,value,isSelected,row,column);
            LexiconTableModel model=(LexiconTableModel)table.getModel();
            String languageURI;
            if (row+1==model.getRowCount())
                languageURI=model.getNewItemLanguageURI();
            else
                languageURI=model.getTableData(row).m_languageURI;
            OIModelerViewable.setFont(languageURI,m_component);
            m_component.getInputContext().selectInputMethod(OIModelerViewable.getLocale(languageURI));
            return m_component;
        }
    }

    /**
     * The editor for the type based on the combo box.
     */
    protected static class ComboBoxChooser extends SmartCellEditor {
        public ComboBoxChooser(Collection collection) {
            super(new JComboBox());
            JComboBox comboBox=(JComboBox)m_component;
            Iterator iterator=collection.iterator();
            while (iterator.hasNext()) {
                String value=(String)iterator.next();
                comboBox.addItem(value);
            }
        }
    }

    /**
     * The selection in a lexicon.
     */
    public static class LexiconSelection {
        public LexicalEntry m_lexicalEntry;
        public Entity m_referencedEntity;
        public String m_value;

        public LexiconSelection(LexicalEntry lexicalEntry,Entity referencedEntity,String value) {
            m_lexicalEntry=lexicalEntry;
            m_referencedEntity=referencedEntity;
            m_value=value;
        }
    }
}
