package de.fzi.wim.oimodeler.inspector;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;

/**
 * The interface representing information about an entity.
 */
public interface EntityInfoPage {
    /**
     * Sets the language URI.
     *
     * @param languageURI           the language URI
     * @throws KAONException        thrown if there is an error
     */
    void setLanguageURI(String languageURI) throws KAONException;
    /**
     * Returns the current entity.
     *
     * @return                      the entity shown
     */
    Entity getCurrentEntity();
    /**
     * Shows given entity in the model.
     *
     * @param entity                the entity shown
     * @throws KAONException        thrown if there is an error
     */
    void showEntity(Entity entity) throws KAONException;
    /**
     * Makes sure nothing is shown in the model.
     */
    void showNothing();
    /**
     * Disposes of the object.
     */
    void dispose();
}
