package de.fzi.wim.oimodeler.inference;

import edu.unika.aifb.kaon.api.oimodel.Concept;
import edu.unika.aifb.kaon.api.oimodel.Instance;
import edu.unika.aifb.kaon.api.oimodel.Property;
import edu.unika.aifb.kaon.api.oimodel.PropertyInstance;
import edu.unika.aifb.kaon.api.oimodel.Entity;
import edu.unika.aifb.kaon.api.oimodel.OIModel;
import edu.unika.aifb.kaon.api.KAONException;

/**
 * Wrapper class for an entity, that is not monitored for changes and deletion.
 */
public class UncoupledEntity {
    /** The uri to the entity. */
    protected String m_uri;
    /** The label of the entity. */
    protected String m_label;
    /** The type of the entity is concept. */
    protected boolean m_isConcept;
    /** The type of the entity is instance. */
    protected boolean m_isInstance;
    /** The type of the entity is property. */
    protected boolean m_isProperty;
    /** The type of the entity is propertyinstance. */
    protected boolean m_isPropertyInstance;

    /**
     * Creates an instance of this class.
     *
     * @param entity                    entity to be uncoupled
     * @param languageUri               uri to the language to be used
     */
    public UncoupledEntity(Entity entity, String languageUri) {
        try {
            updateEntity(entity,languageUri);
        }
        catch (KAONException e) {
        }
    }
    /**
     * Refreshes the entity information.
     *
     * @param entity                    entity to be uncoupled
     * @param languageUri               uri to the language to be used
     * @throws KAONException            thrown if some error occured
     */
    protected void updateEntity(Entity entity, String languageUri) throws KAONException {
        m_isConcept=(entity instanceof Concept);
        m_isInstance=(entity instanceof Instance);
        m_isProperty=(entity instanceof Property);
        m_isPropertyInstance=(entity instanceof PropertyInstance);
        m_uri=entity.getURI();
        m_label=entity.getLabel(languageUri);
        if(m_label==null)
            m_label=m_uri;
    }
    /**
     * Returns the URI of the entity.
     *
     * @return                              URI of this entity
     */
    public String getURI() {
        return m_uri;
    }
    /**
     * Returns the label.
     *
     * @return                              label of the entity
     */
    public String getLabel() {
        return m_label;
    }
    /**
     * Returns <code>true</code> if the entity is an instance of concept.
     *
     * @return                              if the entity is an instance of concept.
     */
    public boolean isConcept() {
        return m_isConcept;
    }
    /**
     * Returns <code>true</code> if the entity is an instance.
     *
     * @return                              if the entity is an instance
     */
    public boolean isInstance() {
        return m_isInstance;
    }
    /**
     * Returns <code>true</code> if the entity is a property.
     *
     * @return                              if the entity is an property
     */
    public boolean isProperty() {
        return m_isProperty;
    }
    /**
     * Returns <code>true</code> if the entity is a property instance.
     *
     * @return                              if the entity is an property instance
     */
    public boolean isPropertyInstance() {
        return m_isPropertyInstance;
    }
    /**
     * Tries to reload the entity by using the given OIModel and the given language.
     *
     * @param   oimodel                     oimodel to be used for loading the entity
     * @return                              the loaded entity
     * @throws KAONException                thrown if some error occured
     */
    public Entity loadEntity(OIModel oimodel) throws KAONException {
        Entity entity=null;
        if (m_isConcept)
            entity=oimodel.getConcept(m_uri);
        else if (m_isInstance)
            entity=oimodel.getInstance(m_uri);
        else if (m_isProperty)
            entity=oimodel.getProperty(m_uri);
        return entity;
    }
}
