package de.fzi.wim.oimodeler.inference;

import de.fzi.wim.guibase.lazytreemodel.DefaultNoChildrenNode;
import de.fzi.wim.guibase.lazytreemodel.LazyTreeModel;
import de.fzi.wim.oimodeler.ui.OIModelerViewable;
import edu.unika.aifb.kaon.api.oimodel.Entity;

/**
 * Tree model showing the OI-model elements without monitoring for changes.
 */
public class InferedOIModelTreeModel extends LazyTreeModel {
    /** The language URI. */
    protected String m_languageURI;

    /**
     * Creates a tree model adapter.
     *
     * @param oimodelerViewable     the OI-modeler viewable
     * @param loader                the loader for nodes
     */
    public InferedOIModelTreeModel(OIModelerViewable oimodelerViewable, InferedOIModelNodeLoader loader) {
        super(null,loader,new DefaultNoChildrenNode(oimodelerViewable.getModule().getAppDriver().getLocalizationManager().getPhrase("oimodeler.loadingWait"),null));
        m_languageURI=oimodelerViewable.getLanguageURI();
        setAsksAllowsChildren(true);
    }
    /**
     * Destroys this tree model.
     */
    public void dispose() {
        showNothing();
    }
    /**
     * Sets the current language URI.
     *
     * @param languageURI           the languageURI
     */
    public void setLanguageURI(String languageURI) {
        m_languageURI=languageURI;
    }
    /**
     * returns the current language URI.
     *
     * @return                      the current languageURI
     */
    public String getLanguageURI() {
        return m_languageURI;
    }
    /**
     * Makes sure nothing is shown in the model.
     */
    public void showNothing() {
        setRoot(null);
    }
    /**
     * Shows given entity in the model.
     *
     * @param entity                the entity shown
     */
    public void showEntity(Entity entity) {
        showNode(new InferedEntityHierarchyNode(null,entity,m_languageURI));
    }
    /**
     * Shows given node as the root.
     *
     * @param root                  the node to show in the root
     */
    public void showNode(InferedOIModelNode root) {
        setRoot(root);
    }
}
