package de.fzi.wim.oimodeler.inference;

import javax.swing.tree.TreeNode;

import de.fzi.wim.guibase.lazytreemodel.*;

/**
 * Node in the tree representing an element of the ontology not monitored for changes.
 */
public abstract class InferedOIModelNode extends AbstractLazyTreeNode {

    /**
     * Creates an adaptor for given concept.
     *
     * @param parent            parent of this node
     */
    public InferedOIModelNode(TreeNode parent) {
        super(parent);
    }
    /**
     * Returns the uncoupled entity for the node.
     *
     * @return                      the uncoupled entity for the node
     */
    public abstract UncoupledEntity getEntity();
    /**
     * Returns the label of the node in the tree.
     *
     * @return                      label of the node in the tree
     */
    public abstract String toString();
}
