package de.fzi.wim.oimodeler.inference;

import java.util.Iterator;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.List;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.tree.TreeNode;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;

import de.fzi.wim.guibase.lazytreemodel.*;

import de.fzi.wim.oimodeler.ui.*;
import de.fzi.wim.oimodeler.viewfilter.*;

/**
 * Node loader for the inferred properties of an instance without monitoring changes.
 */
public class InferedInstancePropertiesNodeLoader extends InferedOIModelNodeLoader {

    /**
     * Creates an instance of this class.
     *
     * @param oimodelerViewable     the OI-modeler viewable
     */
    public InferedInstancePropertiesNodeLoader(OIModelerViewable oimodelerViewable) {
        super(oimodelerViewable);
    }
    /**
     * Loads children of ontology nodes, but throws exceptions if there is a problem.
     *
     * @param model                 model that requested the load
     * @param node                  node whose children need to be loaded
     * @return                      array of loaded children (or {@link #LOAD_DEFERRED} indicating that load will be done later)
     * @throws KAONException        the exception
     */
    protected TreeNode[] loadNodeChildrenEx(LazyTreeModel model,LazyTreeNode node) throws KAONException {
        ViewFilter viewFilter=m_oimodelerViewable.getViewFilter();
        InferedOIModelTreeModel oimodelTreeModel=(InferedOIModelTreeModel)model;
        OIModel oimodel=m_oimodelerViewable.getOIModel();
        Instance instance=(Instance)((InferedEntityHierarchyNode)node).getEntity().loadEntity(oimodel);
        //load the inferenced properties
        Set relatedObjectsToLoad=new HashSet();
        Map propertyValueMap=instance.getAllFromPropertyValues();
        Iterator keys=propertyValueMap.keySet().iterator();
        while(keys.hasNext()) {
            Property property=(Property)keys.next();
            Iterator propertyvalues=((Set)propertyValueMap.get(property)).iterator();
            while(propertyvalues.hasNext()) {
                Object value=propertyvalues.next();
                if(value instanceof Instance) {
                    relatedObjectsToLoad.add(value);
                }
            }
        }
        oimodel.loadObjects(relatedObjectsToLoad,OIModel.LOAD_INSTANCE_BASICS | OIModel.LOAD_PROPERTY_BASICS | OIModel.LOAD_LEXICON);
        //check which of them should be displayed and return them
        List children=new ArrayList();
        keys=propertyValueMap.keySet().iterator();
        while(keys.hasNext()) {
            Property property=(Property)keys.next();
            if (viewFilter.showEntity(property)) {
                Iterator propertyValues=((Set)propertyValueMap.get(property)).iterator();
                while(propertyValues.hasNext()) {
                    InferedPropertyInstanceNode newNode=new InferedPropertyInstanceNode(node,property,propertyValues.next(),oimodelTreeModel.getLanguageURI());
                    newNode.setChildrenLoaded(InferedPropertyInstanceNode.EMPTY_CHILDREN);
                    children.add(newNode);
                }
            }
        }
        TreeNode[] childrenAsArray=new TreeNode[children.size()];
        children.toArray(childrenAsArray);
        return childrenAsArray;
    }
    /**
     * Returns the position at which the supplied node should be inserted.
     *
     * @param node                  the node in whose children insertion is done
     * @param newNode               the new node
     * @return                      the position of the new node
     */
    public int getInsertPosition(InferedOIModelNode node,InferedOIModelNode newNode) {
        TreeNode[] children=node.getChildren();
        for (int i=0;i<children.length;i++) {
            int result=PropertyInstanceNodeComparator.INSTANCE.compare(children[i],newNode);
            if (result>=0)
                return i;
        }
        return children.length;
    }

    /**
     * The comparator for the nodes.
     */
    protected static class PropertyInstanceNodeComparator implements Comparator {
        public static final Comparator INSTANCE=new PropertyInstanceNodeComparator();

        public int compare(Object o1,Object o2) {
            InferedPropertyInstanceNode n1=(InferedPropertyInstanceNode)o1;
            InferedPropertyInstanceNode n2=(InferedPropertyInstanceNode)o2;
            int result=n1.getPropertyLabel().compareToIgnoreCase(n2.getPropertyLabel());
            if (result==0)
                result=n1.getTargetValueLabel().compareToIgnoreCase(n2.getTargetValueLabel());
            return result;
        }
    }
}
