package de.fzi.wim.oimodeler.inference;

import javax.swing.tree.TreeNode;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;

/**
 * Node in the tree representing a hierarchical entity in the ontology.
 */
public class InferedEntityHierarchyNode extends InferedOIModelNode {
    /** Entity represented by this node. */
    protected UncoupledEntity m_entity;

    /**
     * Creates an adaptor for given concept.
     *
     * @param parent            parent of this node
     * @param entity            entity represented by this node
     * @param languageUri       language to be used
     * @throws KAONException        thrown if there is an error
     */
    public InferedEntityHierarchyNode(TreeNode parent, Entity entity, String languageUri) {
        super(parent);
        m_entity=new UncoupledEntity(entity,languageUri);
    }
    /**
     * Returns the label of the node in the tree.
     *
     * @return                      label of the node in the tree
     */
    public String toString() {
        return m_entity.getLabel();
    }
    /**
     * Reutrns the entity of this node.
     *
     * @return                      entity of this node
     */
    public UncoupledEntity getEntity() {
        return m_entity;
    }
}
