package de.fzi.wim.oimodeler.inference;

import javax.swing.Icon;
import javax.swing.tree.TreeNode;

import de.fzi.wim.guibase.lazytreemodel.AbstractLazyTreeNode;
import de.fzi.wim.guibase.lazytreemodel.DefaultNoChildrenNode;
import de.fzi.wim.guibase.lazytreemodel.LazyNodeLoader;
import de.fzi.wim.guibase.lazytreemodel.LazyTreeModel;
import de.fzi.wim.guibase.lazytreemodel.LazyTreeNode;
import de.fzi.wim.guibase.treetable.TreeTableModel;
import de.fzi.wim.oimodeler.ui.OIModelerViewable;
import edu.unika.aifb.kaon.api.oimodel.Entity;

/**
 * Tree table model showing the concept instances without updating.
 */
public class InferedConceptInstancesTreeTableModel extends InferedOIModelTreeModel implements TreeTableModel {
    /** The viewables. */
    protected OIModelerViewable m_oimodelerViewable;
    /** The loader for instance properties. */
    protected InferedOIModelNodeLoader m_instancePropertiesLoader;
    /** The null-loader. */
    protected InferedOIModelNodeLoader m_nullNodeLoader;
    /** The icon for instance. */
    protected Icon m_instance;

    /**
     * Creates a tree model adapter.
     *
     * @param oimodelerViewable     the OI-modeler viewable
     */
    public InferedConceptInstancesTreeTableModel(OIModelerViewable oimodelerViewable) {
        super(oimodelerViewable,new InferedConceptInstancesNodeLoader(oimodelerViewable));
        m_oimodelerViewable=oimodelerViewable;
        m_instancePropertiesLoader=new InferedInstancePropertiesNodeLoader(m_oimodelerViewable);
        m_nullNodeLoader=new NullNodeLoader(m_oimodelerViewable);
        m_instance=m_oimodelerViewable.getModule().getAppDriver().getLocalizationManager().getImageIcon("oimodeler.instance");
    }
    /**
     * Shows given entity in the model indirectly, meaning that another node is added that wraps the entity.
     *
     * @param entity                the entity shown
     */
    public void showEntityIndirectly(Entity entity) {
        showNode(new EntityIndirectionRootNode(entity));
    }
    /**
     * Returns a node loader for given node.
     *
     * @param node                          node for which loader is requested
     * @return                              loader capable of loading children of supplied node
     */
    public LazyNodeLoader getLazyNodeLoader(LazyTreeNode node) {
        if (node instanceof InferedEntityHierarchyNode) {
            UncoupledEntity entity=((InferedEntityHierarchyNode)node).getEntity();
            if (entity.isConcept())
                return m_loader;
            else if (entity.isInstance())
                return m_instancePropertiesLoader;
        }
        return m_nullNodeLoader;
    }
    /**
     * Returns the number of columns in the model.
     *
     * @return                      number of columsn in the model
     */
    public int getColumnCount() {
        return 3;
    }
    /**
     * Returns the name of the column with given index.
     *
     * @param column                index of column for which name is requested
     * @return                      name of column with given index
     */
    public String getColumnName(int column) {
        switch (column) {
        case 0:
            return m_oimodelerViewable.getModule().getAppDriver().getLocalizationManager().getPhrase("oimodeler.entityName");
        case 1:
            return " ";
        case 2:
        default:
            return m_oimodelerViewable.getModule().getAppDriver().getLocalizationManager().getPhrase("oimodeler.value");
        }
    }
    /**
     * Returns the class of the column with given index.
     *
     * @param column                index of column for which class is requested
     * @return                      class of column with given index
     */
    public Class getColumnClass(int column) {
        if (column==1)
            return Icon.class;
        else
            return String.class;
    }
    /**
     * Returns the value from an object at given column.
     *
     * @param node                  node whose value needs to be read
     * @param column                column whose value is requested
     * @return                      value of the column for given node
     */
    public Object getValueAt(Object node,int column) {
        if (node instanceof InferedEntityHierarchyNode) {
            InferedEntityHierarchyNode entityHierarchyNode=(InferedEntityHierarchyNode)node;
            if (column==0)
                return entityHierarchyNode.toString();
        }
        else if (node instanceof InferedPropertyInstanceNode) {
            InferedPropertyInstanceNode propertyInstanceNode=(InferedPropertyInstanceNode)node;
            if (column==0)
                return propertyInstanceNode.getPropertyLabel();
            else if (column==1) {
                if (!propertyInstanceNode.isAttribute())
                    return m_instance;
            }
            else
                return propertyInstanceNode.getTargetValueLabel();
        }
        else if (node instanceof DefaultNoChildrenNode) {
            if (column==0)
                return ((DefaultNoChildrenNode)node).toString();
        }
        return null;
    }
    /**
     * Sets the value from an object at given column.
     *
     * @param aValue                the value being set
     * @param node                  node whose value needs to be read
     * @param column                column whose value is requested
     */
    public void setValueAt(Object aValue,Object node,int column) {
    }
    /**
     * Checks whether cell for given node is editable.
     *
     * @param node                  node that needs to be tested
     * @param column                column that needs to be tested
     * @return                      <code>true</code> if the cell displaying the value is editable
     */
    public boolean isCellEditable(Object node,int column) {
        return false;
    }

    /**
     * The null node loader.
     */
    protected static class NullNodeLoader extends InferedOIModelNodeLoader {
        public NullNodeLoader(OIModelerViewable oimodelerViewable) {
            super(oimodelerViewable);
        }
        protected TreeNode[] loadNodeChildrenEx(LazyTreeModel model,LazyTreeNode node) {
            return AbstractLazyTreeNode.EMPTY_CHILDREN;
        }
        public int getInsertPosition(InferedOIModelNode node,InferedOIModelNode newNode) {
            return node.getChildCount();
        }
    }

    /**
     * The root node. This class adds another level of hierarchy in the tree in order to
     * prevent the tree from expanding the node by default.
     */
    protected class EntityIndirectionRootNode extends InferedOIModelNode {
        public EntityIndirectionRootNode(Entity entity) {
            super(null);
            InferedEntityHierarchyNode node=new InferedEntityHierarchyNode(this,entity,m_languageURI);
            m_children=new TreeNode[] { node };
        }
        public String toString() {
            return "";
        }
        public UncoupledEntity getEntity() {
            return null;
        }
    }
}
