package de.fzi.wim.oimodeler.inference;

import java.util.HashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseAdapter;
import javax.swing.Icon;
import javax.swing.JViewport;
import javax.swing.tree.TreePath;
import javax.swing.table.TableColumn;
import javax.swing.plaf.TableUI;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;

import de.fzi.wim.guibase.selectionsource.*;
import de.fzi.wim.guibase.treetable.*;
import de.fzi.wim.oimodeler.ui.*;

/**
 * Tree-table for showing OI-model nodes.
 */
public class InferedConceptInstancesTreeTable extends AbstractJTreeTableSelectionSource {
    /**
     * @param oimodelerViewable     the viewable for the OI-modeler
     */
    public InferedConceptInstancesTreeTable(final OIModelerViewable oimodelerViewable) {
        super(oimodelerViewable.getOIModelerSelectionSourceManager(),new InferedConceptInstancesTreeTableModel(oimodelerViewable));
        addMouseListener(new MouseAdapter() {
            public void mouseClicked(MouseEvent e) {
                try {
                    if (e.getClickCount()>=2) {
                        int columnIndex=columnAtPoint(e.getPoint());
                        if (columnIndex>=0) {
                            Collection selection=getSelection();
                            if (!selection.isEmpty()) {
                                Collection newSelectedEntities=new HashSet();
                                Iterator iterator=selection.iterator();
                                while (iterator.hasNext()) {
                                    InferedOIModelNode oimodelnode=(InferedOIModelNode)iterator.next();
                                    if (oimodelnode instanceof InferedEntityHierarchyNode)
                                        newSelectedEntities.add(((InferedEntityHierarchyNode)oimodelnode).getEntity().loadEntity(oimodelerViewable.getOIModel()));
                                    else if (oimodelnode instanceof InferedPropertyInstanceNode) {
                                        if (columnIndex==0)
                                            newSelectedEntities.add(((InferedPropertyInstanceNode)oimodelnode).getProperty().loadEntity(oimodelerViewable.getOIModel()));
                                        else if (((InferedPropertyInstanceNode)oimodelnode).getTargetValueInstance()!=null)
                                            newSelectedEntities.add(((InferedPropertyInstanceNode)oimodelnode).getTargetValueInstance().loadEntity(oimodelerViewable.getOIModel()));
                                    }
                                }
                                if (!newSelectedEntities.isEmpty())
                                    oimodelerViewable.getOIModelerSelectionModel().setSelectedEntities(newSelectedEntities);
                            }
                        }
                    }
                }
                catch (KAONException error) {
                    oimodelerViewable.getModule().getAppDriver().displayErrorNotification(error);
                }
            }
        });
        final Icon concept=oimodelerViewable.getModule().getAppDriver().getLocalizationManager().getImageIcon("oimodeler.concept");
        final Icon instance=oimodelerViewable.getModule().getAppDriver().getLocalizationManager().getImageIcon("oimodeler.instance");
        setTreeNodeRenderer(new DefaultTreeNodeRenderer() {
            protected Icon getItemIcon(JTreeTable treeTable,int row) {
                Object node=treeTable.getPathForRow(row).getLastPathComponent();
                if (node instanceof InferedEntityHierarchyNode) {
                    if (((InferedEntityHierarchyNode)node).getEntity().isConcept())
                        return concept;
                    else if (((InferedEntityHierarchyNode)node).getEntity().isInstance())
                        return instance;
                }
                return null;
            }
        });
        new SelectionSourceDragSource(this);
        addToolTipRenderers();
        TableColumn column=getColumnModel().getColumn(1);
        column.setMinWidth(30);
        column.setMaxWidth(30);
        column.setResizable(false);
    }
    /**
     * Destroys this instance.
     */
    public void dispose() {
        ((InferedConceptInstancesTreeTableModel)getTreeTableModel()).dispose();
    }
    /**
     * Updates the UI.
     */
    public void updateUI() {
        super.updateUI();
        Component parent=getParent();
        if (parent instanceof JViewport)
            parent.setBackground(getBackground());
    }
    /**
     * Overridden to set the color of the enclosing viewport.
     */
    protected void configureEnclosingScrollPane() {
        super.configureEnclosingScrollPane();
        Component parent=getParent();
        if (parent instanceof JViewport)
            parent.setBackground(getBackground());
    }
    /**
     * Overridden to set the non-dragging UI. Drag-and-drop and the UI don't work well together.
     *
     * @param ui                                            the UI (ignored)
     */
    public void setUI(TableUI ui) {
        super.setUI(new SelectionSourceDragSource.NoDragSelectionTableUI());
    }
    /**
     * Sets the language URI.
     *
     * @param languageURI           the language URI
     */
    public void setLanguageURI(String languageURI) {
        OIModelerViewable.setFont(languageURI,this);
        ((InferedConceptInstancesTreeTableModel)getTreeTableModel()).setLanguageURI(languageURI);
    }
    /**
     * Shows given entity in the model.
     *
     * @param entity                the entity shown
     */
    public void showEntity(Entity entity) {
        ((InferedConceptInstancesTreeTableModel)getTreeTableModel()).showEntity(entity);
    }
    /**
     * Shows given entity in the model indirectly.
     *
     * @param entity                the entity shown
     */
    public void showEntityIndirectly(Entity entity) {
        ((InferedConceptInstancesTreeTableModel)getTreeTableModel()).showEntityIndirectly(entity);
    }
    /**
     * Makes sure nothing is shown in the model.
     */
    public void showNothing() {
        ((InferedConceptInstancesTreeTableModel)getTreeTableModel()).showNothing();
    }
    /**
     * Returns the current selection.
     *
     * @return                                  the collection of selected uncoupled oimodel nodes
     */
    public Collection getSelection() {
        TreePath[] selectedPaths=getSelectionPaths();
        if (selectedPaths==null)
            return Collections.EMPTY_SET;
        else {
            Collection selection=new HashSet();
            for (int i=0;i<selectedPaths.length;i++) {
                Object object=selectedPaths[i].getLastPathComponent();
                if (object instanceof InferedOIModelNode)
                    selection.add(object);
            }
            return selection;
        }
    }
}
