package de.fzi.wim.oimodeler.inference;

import java.util.Set;
import java.util.HashSet;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;

import de.fzi.wim.oimodeler.ui.*;

/**
 * Node loader for concept instances hierarchy without monitoring changes.
 */
public class InferedConceptInstancesNodeLoader extends InferedEntityHierarchyNodeLoader {
    /**
     * Creates an instance of this class.
     *
     * @param oimodelerViewable     the OI-modeler viewable
     */
    public InferedConceptInstancesNodeLoader(OIModelerViewable oimodelerViewable) {
        super(oimodelerViewable);
    }
    /**
     * Returns the load flag for related entities.
     *
     * @return                      the load flag
     */
    protected int getRelatedEntitiesLoadFlag() {
        return OIModel.LOAD_INSTANCE_BASICS | OIModel.LOAD_LEXICON;
    }
    /**
     * Returns the set of related entities.
     *
     * @param entity                the entity
     * @param oimodel               the oimodel to load from
     * @param languageUri           the language used for loading
     * @return                      the set of related entities
     * @throws KAONException        thrown if there is an error
     */
    protected Set getRelatedEntities(UncoupledEntity entity,OIModel oimodel,String languageUri) throws KAONException {
        Set result=new HashSet();
        if (entity.isConcept()) {
            Concept concept=(Concept)entity.loadEntity(oimodel);
            entity.updateEntity(concept,languageUri);
            return concept.getAllInstances();
        }
        return result;
    }
}
