package de.fzi.wim.oimodeler.inclusion;

import java.util.List;
import java.util.LinkedList;
import java.util.Collection;
import java.util.Collections;
import java.awt.Insets;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JLabel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;

import de.fzi.wim.guibase.selectionsource.*;

import de.fzi.wim.oimodeler.ui.*;

/**
 * The pane for the OI-model inclusion.
 */
public class OIModelInclusionPane extends JPanel {
    /** The OI-modeler viewable. */
    protected OIModelerViewable m_oimodelerViewable;
    /** The OI-model inclusion tree. */
    protected JTree m_oimodelInclusionTree;
    /** The active OI-model. */
    protected OIModel m_activeOIModel;

    /**
     * Creates an instance of this class.
     *
     * @param oimodelerViewable                 the OI-modeler viewable
     * @throws KAONException                    thrown if there is an error
     */
    public OIModelInclusionPane(OIModelerViewable oimodelerViewable) throws KAONException {
        super(new GridBagLayout());
        m_oimodelerViewable=oimodelerViewable;
        m_oimodelInclusionTree=new AbstractJTreeSelectionSource(m_oimodelerViewable.getOIModelerSelectionSourceManager(),new OIModelInclusionTreeModel(oimodelerViewable)) {
            public Collection getSelection() {
                TreePath treePath=getSelectionPath();
                if (treePath==null)
                    return Collections.EMPTY_SET;
                else
                    return Collections.singleton(treePath.getLastPathComponent());
            }
        };
        m_oimodelInclusionTree.setShowsRootHandles(true);
        m_oimodelInclusionTree.getSelectionModel().setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);
        m_oimodelInclusionTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener() {
            public void valueChanged(TreeSelectionEvent e) {
                TreePath treePath=m_oimodelInclusionTree.getSelectionPath();
                if (treePath==null)
                    setActiveOIModel(m_oimodelerViewable.getActiveOIModel());
                else {
                    OIModelInclusionTreeModel.OIModelNode node=(OIModelInclusionTreeModel.OIModelNode)treePath.getLastPathComponent();
                    setActiveOIModel(node.getOIModel());
                }
            }
        });
        setActiveOIModel(m_oimodelerViewable.getOIModel());
        DefaultTreeCellRenderer cellRenderer=new DefaultTreeCellRenderer();
        cellRenderer.setOpenIcon(null);
        cellRenderer.setClosedIcon(null);
        cellRenderer.setLeafIcon(null);
        m_oimodelInclusionTree.setCellRenderer(cellRenderer);
        JLabel label=m_oimodelerViewable.getModule().getAppDriver().getLocalizationManager().getLabel("oimodeler.includedOIModels");
        label.setHorizontalAlignment(JLabel.LEFT);
        GridBagConstraints gbc=new GridBagConstraints(0,0,1,1,1.0,0.0,GridBagConstraints.CENTER,GridBagConstraints.HORIZONTAL,new Insets(5,5,5,5),0,0);
        add(label,gbc);
        gbc.gridy++;
        gbc.fill=GridBagConstraints.BOTH;
        gbc.weighty=1.0;
        gbc.gridy++;
        gbc.insets.top=0;
        add(new JScrollPane(m_oimodelInclusionTree),gbc);
    }
    /**
     * Disposes of the inspector.
     */
    public void dispose() {
        if (m_oimodelInclusionTree!=null) {
            ((OIModelInclusionTreeModel)m_oimodelInclusionTree.getModel()).dispose();
            m_oimodelInclusionTree=null;
        }
    }
    /**
     * Sets the active OI-model.
     *
     * @param oimodel                           the active OI-model
     */
    public void setActiveOIModel(OIModel oimodel) {
        OIModel oldActiveOIModel=m_activeOIModel;
        if (oimodel==null)
            m_activeOIModel=m_oimodelerViewable.getOIModel();
        else
            m_activeOIModel=oimodel;
        TreePath treePath=m_oimodelInclusionTree.getSelectionPath();
        if (treePath==null || ((OIModelInclusionTreeModel.OIModelNode)treePath.getLastPathComponent()).getOIModel()!=m_activeOIModel) {
            // apply the breadth-first search to locate the first model in the tree
            OIModelInclusionTreeModel model=(OIModelInclusionTreeModel)m_oimodelInclusionTree.getModel();
            boolean found=false;
            if (model.getRoot()!=null) {
                List queue=new LinkedList();
                queue.add(model.getRoot());
                while (!queue.isEmpty()) {
                    OIModelInclusionTreeModel.OIModelNode node=(OIModelInclusionTreeModel.OIModelNode)queue.remove(0);
                    if (node.getOIModel()==m_activeOIModel) {
                        TreePath newTreePath=new TreePath(model.getPathToRoot(node));
                        m_oimodelInclusionTree.setSelectionPath(newTreePath);
                        m_oimodelInclusionTree.expandPath(newTreePath);
                        found=true;
                        break;
                    }
                    int index=node.getChildCount();
                    for (int i=0;i<index;i++)
                        queue.add(node.getChildAt(i));
                }
                if (!found) {
                    m_activeOIModel=m_oimodelerViewable.getActiveOIModel();
                    m_oimodelInclusionTree.setSelectionRow(0);
                }
            }
        }
        firePropertyChange("activeOIModel",oldActiveOIModel,m_activeOIModel);
    }
    /**
     * Returns the active OI-model.
     *
     * @return                                  the active OI-model
     */
    public OIModel getActiveOIModel() {
        return m_activeOIModel;
    }
}
