package de.fzi.wim.oimodeler.entitylist;

import java.util.HashSet;
import java.util.Collection;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JViewport;
import javax.swing.table.TableColumn;
import javax.swing.plaf.TableUI;

import edu.unika.aifb.kaon.api.*;

import de.fzi.wim.guibase.menus.*;
import de.fzi.wim.guibase.selectionsource.*;

import de.fzi.wim.oimodeler.ui.*;

/**
 * The table displaying a list of entities.
 */
public class OIModelEntityTable extends AbstractJTableSelectionSource {
    /**
     * Creates an instance of this class and attaches it to the editor module.
     *
     * @param oimodelerViewable                             the OI-modeler viewable
     */
    public OIModelEntityTable(OIModelerViewable oimodelerViewable) {
        this(oimodelerViewable,new OIModelEntityTableModel(oimodelerViewable));
        addToolTipRenderers();
    }
    /**
     * Creates an instance of this class and attaches it to the editor module.
     *
     * @param oimodelerViewable                             the OI-modeler viewable
     * @param oimodelEntityTableModel                       the table model
     */
    public OIModelEntityTable(OIModelerViewable oimodelerViewable,OIModelEntityTableModel oimodelEntityTableModel) {
        super(oimodelerViewable.getOIModelerSelectionSourceManager(),oimodelEntityTableModel);
        new SelectionSourceDragSource(this);
        new JTablePopupMenuManipulator(this,oimodelerViewable.getModule().getAppDriver().createPopupMenu("popup.oimodeler.selection"));
        addToolTipRenderers();
        TableColumn column=getColumnModel().getColumn(0);
        column.setMinWidth(20);
        column.setMaxWidth(20);
        column.setResizable(false);
    }
    /**
     * Updates the UI.
     */
    public void updateUI() {
        super.updateUI();
        Component parent=getParent();
        if (parent instanceof JViewport)
            parent.setBackground(getBackground());
    }
    /**
     * Overridden to set the color of the enclosing viewport.
     */
    protected void configureEnclosingScrollPane() {
        super.configureEnclosingScrollPane();
        Component parent=getParent();
        if (parent instanceof JViewport)
            parent.setBackground(getBackground());
    }
    /**
     * Overridden to set the non-dragging UI. Drag-and-drop and the UI don't work well together.
     *
     * @param ui                                            the UI (ignored)
     */
    public void setUI(TableUI ui) {
        super.setUI(new SelectionSourceDragSource.NoDragSelectionTableUI());
    }
    /**
     * Sets the current background color. Overridden to update the enclosing viewport's color as well.
     *
     * @param color                                         the color
     */
    public void setBackground(Color color) {
        super.setBackground(color);
        if (getParent() instanceof JViewport)
            getParent().setBackground(color);
    }
    /**
     * Disposes of this table.
     */
    public void dispose() {
        ((OIModelEntityTableModel)getModel()).dispose();
    }
    /**
     * Returns the current selection.
     *
     * @return                                  the collection of selected entities
     */
    public Collection getSelection() {
        OIModelEntityTableModel model=(OIModelEntityTableModel)getModel();
        int[] selectedRows=getSelectedRows();
        Collection selection=new HashSet();
        for (int i=0;i<selectedRows.length;i++)
            selection.add(model.getEntity(selectedRows[i]));
        return selection;
    }
    /**
     * Sets the language that should be shown.
     *
     * @param languageURI                                   the language URI
     * @throws KAONException                                thrown if there is an error
     */
    public void setLanguageURI(String languageURI) throws KAONException {
        OIModelerViewable.setFont(languageURI,this);
        ((OIModelEntityTableModel)getModel()).setLanguageURI(languageURI);
    }
}
