package de.fzi.wim.oimodeler.entityhierarchy;

import java.util.Set;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.api.change.*;

import de.fzi.wim.oimodeler.ui.*;

/**
 * Node loader for superproperty hierarchy.
 */
public class SuperPropertyHierarchyNodeLoader extends EntityHierarchyNodeLoader {
    /**
     * Creates an instance of this class.
     *
     * @param oimodelerViewable     the OI-modeler viewable
     */
    public SuperPropertyHierarchyNodeLoader(OIModelerViewable oimodelerViewable) {
        super(oimodelerViewable);
    }
    /**
     * Returns the load flag for related entities.
     *
     * @return                      the load flag
     */
    protected int getRelatedEntitiesLoadFlag() {
        return OIModel.LOAD_PROPERTY_BASICS | OIModel.LOAD_LEXICON;
    }
    /**
     * Returns the set of related entities.
     *
     * @param entity                the entity
     * @return                      the set of related entities
     * @throws KAONException        thrown if there is an error
     */
    protected Set getRelatedEntities(Entity entity) throws KAONException {
        return ((Property)entity).getSuperProperties();
    }
    /**
     * Examines the given event and returns the entity that must be added to the given node as child. If no node
     * should be generated for this event, <code>null</code> is returned.
     *
     * @param entity                the entity
     * @param changeEvent           the event
     * @return                      the entity that should be added as child (or <code>null</code> if no entity should be added)
     */
    public Entity getAddedChild(Entity entity,ChangeEvent changeEvent) {
        if (changeEvent instanceof AddSubProperty) {
            AddSubProperty addSubProperty=(AddSubProperty)changeEvent;
            if (addSubProperty.getSubProperty().equals(entity))
                return addSubProperty.getSuperProperty();
        }
        return null;
    }
    /**
     * Examines the given event and returns the entity that must be removed from the given node as child. If no node
     * should be removed for this event, <code>null</code> is returned.
     *
     * @param entity                the entity
     * @param changeEvent           the event
     * @return                      the entity that should be removed as child (or <code>null</code> if no entity should be removed)
     */
    public Entity getRemovedChild(Entity entity,ChangeEvent changeEvent) {
        if (changeEvent instanceof RemoveSubProperty) {
            RemoveSubProperty removeSubProperty=(RemoveSubProperty)changeEvent;
            if (removeSubProperty.getSubProperty().equals(entity))
                return removeSubProperty.getSuperProperty();
        }
        return null;
    }
    /**
     * Returns the event for associating entities. If entities cannot be associated, <code>null</code>
     * is returned.
     *
     * @param superEntity           the superentity
     * @param subEntity             the subentity
     * @return                      the event for associating entityes
     */
    public ChangeEvent getEntityAssociationEvent(Entity superEntity,Entity subEntity) {
        if ((superEntity instanceof Property) && (subEntity instanceof Property))
            return new AddSubProperty(m_oimodelerViewable.getActiveOIModel(),null,(Property)subEntity,(Property)superEntity);
        else
            return null;
    }
}
