package de.fzi.wim.oimodeler.entityhierarchy;

import javax.swing.tree.TreeNode;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;

/**
 * Node in the tree representing a property instance in the ontology.
 */
public class PropertyInstanceNode extends OIModelNode {
    /** Property instance represented by this node. */
    protected PropertyInstance m_propertyInstance;
    /** The property label. */
    protected String m_propertyLabel;
    /** The target value label. */
    protected String m_targetValueLabel;
    /** Set to <code>true</code> if this property is an attribute. */
    protected boolean m_isAttribute;

    /**
     * Creates an adaptor for given concept.
     *
     * @param parent                parent of this node
     * @param propertyInstance      property instance represented by this node
     * @throws KAONException        thrown if there is an error
     */
    public PropertyInstanceNode(TreeNode parent,PropertyInstance propertyInstance) throws KAONException {
        super(parent);
        m_propertyInstance=propertyInstance;
        m_isAttribute=m_propertyInstance.getProperty().isAttribute();
    }
    /**
     * Returns the object for the node.
     *
     * @return                      the object for the node
     */
    public Object getObject() {
        return m_propertyInstance;
    }
    /**
     * Returns the property instance.
     *
     * @return                      the property instance
     */
    public PropertyInstance getPropertyInstance() {
        return m_propertyInstance;
    }
    /**
     * Updates this node.
     *
     * @param languageURI           the URI of the language
     * @throws KAONException        thrown if there is an error
     */
    public void setLanguageURI(String languageURI) throws KAONException {
        m_propertyLabel=m_propertyInstance.getProperty().getLabel(languageURI);
        if (m_propertyLabel==null)
            m_propertyLabel=m_propertyInstance.getProperty().getURI();
        Object targetValue=m_propertyInstance.getTargetValue();
        if (targetValue instanceof Instance) {
            Instance targetInstance=(Instance)targetValue;
            m_targetValueLabel=targetInstance.getLabel(languageURI);
            if (m_targetValueLabel==null)
                m_targetValueLabel=targetInstance.getURI();
        }
        else
            m_targetValueLabel=targetValue.toString();
    }
    /**
     * Returns the label of the property.
     *
     * @return                      the label of the property
     */
    public String getPropertyLabel() {
        return m_propertyLabel;
    }
    /**
     * Returns the label of the target value.
     *
     * @return                      the label of the target value
     */
    public String getTargetValueLabel() {
        return m_targetValueLabel;
    }
    /**
     * Returns whether the node is an attribute node.
     *
     * @return                      <code>true</code> if the node is an attribute
     */
    public boolean isAttribute() {
        return m_isAttribute;
    }
    /**
     * Returns <code>false</code>.
     *
     * @return                      always <code>false</code>, since this node can't have children
     */
    public boolean getAllowsChildren() {
        return false;
    }
    /**
     * Changes the value of the property instance.
     *
     * @param newTargetValue        the new target value
     * @throws KAONException        thrown if there is an error
     */
    public void setNewTargetValue(Object newTargetValue) throws KAONException {
        PropertyInstance newPropertyInstance=m_propertyInstance.getOIModel().getPropertyInstance(m_propertyInstance.getProperty(),m_propertyInstance.getSourceInstance(),newTargetValue);
        m_propertyInstance=newPropertyInstance;
        m_isAttribute=m_propertyInstance.getProperty().isAttribute();
    }
}
