package de.fzi.wim.oimodeler.entityhierarchy;

import java.util.Set;
import java.util.Iterator;
import java.util.List;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.tree.TreeNode;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.api.change.*;

import de.fzi.wim.guibase.lazytreemodel.*;

import de.fzi.wim.oimodeler.ui.*;
import de.fzi.wim.oimodeler.viewfilter.*;

/**
 * Node loader for parent concept hierarchy.
 */
public class ParentConceptHierarchyNodeLoader extends SuperConceptHierarchyNodeLoader {
    /**
     * Creates an instance of this class.
     *
     * @param oimodelerViewable     the OI-modeler viewable
     */
    public ParentConceptHierarchyNodeLoader(OIModelerViewable oimodelerViewable) {
        super(oimodelerViewable);
    }
    /**
     * Loads children of ontology nodes.
     *
     * @param model                 model that requested the load
     * @param node                  node whose children need to be loaded
     * @return                      array of loaded children (or {@link #LOAD_DEFERRED} indicating that load will be done later)
     * @throws KAONException        thrown if there is a problem
     */
    protected TreeNode[] loadNodeChildrenEx(LazyTreeModel model,LazyTreeNode node) throws KAONException {
        Entity entity=((EntityHierarchyNode)node).getEntity();
        if (entity instanceof Instance) {
            ViewFilter viewFilter=m_oimodelerViewable.getViewFilter();
            OIModelTreeModel oimodelTreeModel=(OIModelTreeModel)model;
            OIModel oimodel=entity.getOIModel();
            Set entities=((Instance)entity).getParentConcepts();
            oimodel.loadObjects(entities,OIModel.LOAD_CONCEPT_BASICS | OIModel.LOAD_LEXICON);
            List children=new ArrayList(entities.size());
            Iterator elements=entities.iterator();
            while (elements.hasNext()) {
                Entity child=(Entity)elements.next();
                if (viewFilter.showEntity(child)) {
                    EntityHierarchyNode newNode=new EntityHierarchyNode(node,child);
                    newNode.setLanguageURI(oimodelTreeModel.getLanguageURI());
                    children.add(newNode);
                }
            }
            TreeNode[] childrenAsArray=new TreeNode[children.size()];
            children.toArray(childrenAsArray);
            Arrays.sort(childrenAsArray,NodeLabelComparator.INSTANCE);
            return childrenAsArray;
        }
        else
            return super.loadNodeChildrenEx(model,node);
    }
    /**
     * Examines the given event and returns the concept that must be added to the given node as child. If no node
     * should be generated for this event, <code>null</code> is returned.
     *
     * @param entity                the entity
     * @param changeEvent           the event
     * @return                      the entity that should be added as child (or <code>null</code> if no entity should be added)
     */
    public Entity getAddedChild(Entity entity,ChangeEvent changeEvent) {
        if ((entity instanceof Instance) && (changeEvent instanceof AddInstanceOf)) {
            AddInstanceOf addInstanceOf=(AddInstanceOf)changeEvent;
            if (addInstanceOf.getInstance().equals(entity))
                return addInstanceOf.getConcept();
        }
        return super.getAddedChild(entity,changeEvent);
    }
    /**
     * Examines the given event and returns the entity that must be removed from the given node as child. If no node
     * should be removed for this event, <code>null</code> is returned.
     *
     * @param entity                the entity
     * @param changeEvent           the event
     * @return                      the entity that should be removed as child (or <code>null</code> if no entity should be removed)
     */
    public Entity getRemovedChild(Entity entity,ChangeEvent changeEvent) {
        if ((entity instanceof Instance) && (changeEvent instanceof RemoveInstanceOf)) {
            RemoveInstanceOf removeInstanceOf=(RemoveInstanceOf)changeEvent;
            if (removeInstanceOf.getInstance().equals(entity))
                return removeInstanceOf.getConcept();
        }
        return super.getRemovedChild(entity,changeEvent);
    }
    /**
     * Returns the event for associating entities. If entities cannot be associated, <code>null</code>
     * is returned.
     *
     * @param superEntity           the superentity
     * @param subEntity             the subentity
     * @return                      the event for associating entityes
     */
    public ChangeEvent getEntityAssociationEvent(Entity superEntity,Entity subEntity) {
        if ((superEntity instanceof Instance) && (subEntity instanceof Concept))
            return new AddInstanceOf(m_oimodelerViewable.getActiveOIModel(),null,(Concept)subEntity,(Instance)superEntity);
        return super.getEntityAssociationEvent(superEntity,subEntity);
    }
}
