package de.fzi.wim.oimodeler.entityhierarchy;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.LinkedList;
import java.util.HashSet;
import java.util.Iterator;
import java.io.IOException;
import java.awt.Component;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.datatransfer.UnsupportedFlavorException;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import javax.swing.tree.DefaultTreeCellRenderer;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.api.change.*;

import de.fzi.wim.guibase.selectionsource.*;
import de.fzi.wim.guibase.dnd.*;
import de.fzi.wim.guibase.lazytreemodel.*;

import de.fzi.wim.oimodeler.inspector.*;
import de.fzi.wim.oimodeler.ui.*;

/**
 * Tree for displaying OI-model elements.
 */
public class OIModelTree extends AbstractJTreeSelectionSource implements EntityInfoPage {
    /** The viewable of the OI-model. */
    protected OIModelerViewable m_oimodelerViewable;

    /**
     * Creates an instance of this class and attaches it to the editor module.
     *
     * @param oimodelerViewable     the viewable for the OI-modeler
     * @param loader                the loader for nodes
     */
    public OIModelTree(OIModelerViewable oimodelerViewable,OIModelNodeLoader loader) {
        super(oimodelerViewable.getOIModelerSelectionSourceManager(),new OIModelTreeModel(oimodelerViewable,loader));
        m_oimodelerViewable=oimodelerViewable;
        new SelectionSourceDragSource(this);
        new OIModelTreeDropTarget();
    }
    /**
     * Sets the icon for the node.
     *
     * @param nodeIcon              the icon
     */
    public void setNodeIcon(Icon nodeIcon) {
        DefaultTreeCellRenderer renderer=new DefaultTreeCellRenderer() {
            public Component getTreeCellRendererComponent(JTree tree,Object value,boolean selected,boolean expanded,boolean leaf,int row,boolean hasFocus) {
                super.getTreeCellRendererComponent(tree,value,selected,expanded,leaf,row,hasFocus);
                if (value instanceof DefaultNoChildrenNode)
                    setIcon(null);
                return this;
            }
        };
        renderer.setOpenIcon(nodeIcon);
        renderer.setClosedIcon(nodeIcon);
        renderer.setLeafIcon(nodeIcon);
        setCellRenderer(renderer);
    }
    /**
     * Destroys this instance.
     */
    public void dispose() {
        ((OIModelTreeModel)getModel()).dispose();
        setModel(null);
    }
    /**
     * Sets the language URI.
     *
     * @param languageURI           the language URI
     * @throws KAONException        thrown if there is an error
     */
    public void setLanguageURI(String languageURI) throws KAONException {
        OIModelerViewable.setFont(languageURI,this);
        ((OIModelTreeModel)getModel()).setLanguageURI(languageURI);
    }
    /**
     * Returns the current entity.
     *
     * @return                      the entity shown
     */
    public Entity getCurrentEntity() {
        return ((OIModelTreeModel)getModel()).getCurrentEntity();
    }
    /**
     * Shows given entity in the model.
     *
     * @param entity                the entity shown
     * @throws KAONException        thrown if there is an error
     */
    public void showEntity(Entity entity) throws KAONException {
        ((OIModelTreeModel)getModel()).showEntity(entity);
    }
    /**
     * Makes sure nothing is shown in the model.
     */
    public void showNothing() {
        ((OIModelTreeModel)getModel()).showNothing();
    }
    /**
     * Returns the current selection.
     *
     * @return                                  the collection of selected entities
     */
    public Collection getSelection() {
        TreePath[] selectedPaths=getSelectionPaths();
        if (selectedPaths==null)
            return Collections.EMPTY_SET;
        else {
            Collection selection=new HashSet();
            for (int i=0;i<selectedPaths.length;i++) {
                Object object=selectedPaths[i].getLastPathComponent();
                if (object instanceof OIModelNode) {
                    OIModelNode node=(OIModelNode)object;
                    selection.add(node.getObject());
                }
            }
            return selection;
        }
    }

    /**
     * The drop target for the tree.
     */
    protected class OIModelTreeDropTarget extends JTreeDropTarget {
        public OIModelTreeDropTarget() {
            super(OIModelTree.this,null);
        }
        protected boolean acceptsDrag(DropTargetDragEvent dtde,int draggingRow) {
            return dtde.isDataFlavorSupported(CollectionSelection.s_objectCollectionFlavor);
        }
        protected boolean processDrop(DropTargetDropEvent dtde,TreePath droppedPath) {
            if (droppedPath==null)
                return false;
            Collection collection;
            try {
                collection=(Collection)dtde.getTransferable().getTransferData(CollectionSelection.s_objectCollectionFlavor);
            }
            catch (IOException ignored) {
                return false;
            }
            catch (UnsupportedFlavorException ignored) {
                return false;
            }
            Object object=droppedPath.getLastPathComponent();
            if (object instanceof OIModelNode) {
                OIModelNode node=(OIModelNode)object;
                OIModelNodeLoader loader=(OIModelNodeLoader)((OIModelTreeModel)getModel()).getLazyNodeLoader(node);
                List list=new LinkedList();
                Iterator iterator=collection.iterator();
                while (iterator.hasNext()) {
                    Object droppedObject=iterator.next();
                    ChangeEvent changeEvent=loader.getAssociationEvent(node,droppedObject);
                    if (changeEvent!=null)
                        list.add(changeEvent);
                }
                if (!list.isEmpty()) {
                    m_oimodelerViewable.changeOIModel(list);
                    return true;
                }
            }
            return false;
        }
    }
}
