package de.fzi.wim.oimodeler.entityhierarchy;

import javax.swing.tree.TreeNode;

import edu.unika.aifb.kaon.api.*;

import de.fzi.wim.guibase.lazytreemodel.*;

/**
 * Node in the tree representing an element of the ontology.
 */
public abstract class OIModelNode extends AbstractLazyTreeNode {

    /**
     * Creates an adaptor for given concept.
     *
     * @param parent            parent of this node
     */
    public OIModelNode(TreeNode parent) {
        super(parent);
    }
    /**
     * Updates this node.
     *
     * @param languageURI           the URI of the language
     * @throws KAONException        thrown if there is an error
     */
    public abstract void setLanguageURI(String languageURI) throws KAONException;
    /**
     * Returns the object for the node.
     *
     * @return                      the object for the node
     */
    public abstract Object getObject();
}
