package de.fzi.wim.oimodeler.entityhierarchy;

import javax.swing.tree.TreeNode;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;

/**
 * Node in the tree representing a hierarchical entity in the ontology.
 */
public class EntityHierarchyNode extends OIModelNode {
    /** Entity represented by this node. */
    protected Entity m_entity;
    /** The textual label of the node. */
    protected String m_label;

    /**
     * Creates an adaptor for given concept.
     *
     * @param parent            parent of this node
     * @param entity            entity represented by this node
     */
    public EntityHierarchyNode(TreeNode parent,Entity entity) {
        super(parent);
        m_entity=entity;
    }
    /**
     * Returns the object for the node.
     *
     * @return                      the object for the node
     */
    public Object getObject() {
        return m_entity;
    }
    /**
     * Returns the label of the node in the tree.
     *
     * @return                      label of the node in the tree
     */
    public String toString() {
        return m_label;
    }
    /**
     * Reutrns the entity of this node.
     *
     * @return                      entity of this node
     */
    public Entity getEntity() {
        return m_entity;
    }
    /**
     * Updates this node.
     *
     * @param languageURI           the URI of the language
     * @throws KAONException        thrown if there is an error
     */
    public void setLanguageURI(String languageURI) throws KAONException {
        m_label=m_entity.getLabel(languageURI);
        if (m_label==null)
            m_label=m_entity.getURI();
    }
}
