package de.fzi.wim.oimodeler.entityhierarchy;

import java.util.HashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseAdapter;
import javax.swing.Icon;
import javax.swing.JViewport;
import javax.swing.JTextField;
import javax.swing.tree.TreePath;
import javax.swing.table.TableColumn;
import javax.swing.plaf.TableUI;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;

import de.fzi.wim.guibase.selectionsource.*;
import de.fzi.wim.guibase.treetable.*;
import de.fzi.wim.guibase.tables.*;
import de.fzi.wim.guibase.menus.*;

import de.fzi.wim.oimodeler.ui.*;
import de.fzi.wim.oimodeler.inspector.*;

/**
 * Tree-table for showing OI-model nodes.
 */
public class ConceptInstancesTreeTable extends AbstractJTreeTableSelectionSource implements EntityInfoPage {
    /**
     * @param oimodelerViewable     the viewable for the OI-modeler
     */
    public ConceptInstancesTreeTable(final OIModelerViewable oimodelerViewable) {
        super(oimodelerViewable.getOIModelerSelectionSourceManager(),new ConceptInstancesTreeTableModel(oimodelerViewable));
        addMouseListener(new MouseAdapter() {
            public void mouseClicked(MouseEvent e) {
                try {
                    if (e.getClickCount()>=2) {
                        int columnIndex=columnAtPoint(e.getPoint());
                        if (columnIndex>=0) {
                            Collection selection=getSelection();
                            if (!selection.isEmpty()) {
                                Collection newSelectedEntities=new HashSet();
                                Iterator iterator=selection.iterator();
                                while (iterator.hasNext()) {
                                    Object object=iterator.next();
                                    if (object instanceof Entity)
                                        newSelectedEntities.add(object);
                                    else if (object instanceof PropertyInstance) {
                                        PropertyInstance propertyInstance=(PropertyInstance)object;
                                        if (columnIndex==0)
                                            newSelectedEntities.add(propertyInstance.getProperty());
                                        else if (propertyInstance.getTargetValue() instanceof Instance)
                                            newSelectedEntities.add(propertyInstance.getTargetValue());
                                    }
                                }
                                if (!newSelectedEntities.isEmpty())
                                    oimodelerViewable.getOIModelerSelectionModel().setSelectedEntities(newSelectedEntities);
                            }
                        }
                    }
                }
                catch (KAONException error) {
                    oimodelerViewable.getModule().getAppDriver().displayErrorNotification(error);
                }
            }
        });
        new JTablePopupMenuManipulator(this,oimodelerViewable.getModule().getAppDriver().createPopupMenu("popup.oimodeler.selection"));
        final Icon concept=oimodelerViewable.getModule().getAppDriver().getLocalizationManager().getImageIcon("oimodeler.concept");
        final Icon instance=oimodelerViewable.getModule().getAppDriver().getLocalizationManager().getImageIcon("oimodeler.instance");
        setTreeNodeRenderer(new DefaultTreeNodeRenderer() {
            protected Icon getItemIcon(JTreeTable treeTable,int row) {
                Object node=treeTable.getPathForRow(row).getLastPathComponent();
                if (node instanceof EntityHierarchyNode) {
                    EntityHierarchyNode entityHierarchyNode=(EntityHierarchyNode)node;
                    if (entityHierarchyNode.getEntity() instanceof Concept)
                        return concept;
                    else if (entityHierarchyNode.getEntity() instanceof Instance)
                        return instance;
                }
                return null;
            }
        });
        new SelectionSourceDragSource(this);
        setDefaultEditor(String.class,new SmartCellEditor(new JTextField()));
        addToolTipRenderers();
        TableColumn column=getColumnModel().getColumn(1);
        column.setMinWidth(30);
        column.setMaxWidth(30);
        column.setResizable(false);
    }
    /**
     * Destroys this instance.
     */
    public void dispose() {
        ((ConceptInstancesTreeTableModel)getTreeTableModel()).dispose();
    }
    /**
     * Updates the UI.
     */
    public void updateUI() {
        super.updateUI();
        Component parent=getParent();
        if (parent instanceof JViewport)
            parent.setBackground(getBackground());
    }
    /**
     * Overridden to set the color of the enclosing viewport.
     */
    protected void configureEnclosingScrollPane() {
        super.configureEnclosingScrollPane();
        Component parent=getParent();
        if (parent instanceof JViewport)
            parent.setBackground(getBackground());
    }
    /**
     * Overridden to set the non-dragging UI. Drag-and-drop and the UI don't work well together.
     *
     * @param ui                                            the UI (ignored)
     */
    public void setUI(TableUI ui) {
        super.setUI(new SelectionSourceDragSource.NoDragSelectionTableUI());
    }
    /**
     * Sets the language URI.
     *
     * @param languageURI           the language URI
     * @throws KAONException        thrown if there is an error
     */
    public void setLanguageURI(String languageURI) throws KAONException {
        OIModelerViewable.setFont(languageURI,this);
        ((ConceptInstancesTreeTableModel)getTreeTableModel()).setLanguageURI(languageURI);
    }
    /**
     * Shows given entity in the model.
     *
     * @param entity                the entity shown
     * @throws KAONException        thrown if there is an error
     */
    public void showEntity(Entity entity) throws KAONException {
        ((ConceptInstancesTreeTableModel)getTreeTableModel()).showEntity(entity);
    }
    /**
     * Shows given entity in the model indirectly.
     *
     * @param entity                the entity shown
     * @throws KAONException        thrown if there is an error
     */
    public void showEntityIndirectly(Entity entity) throws KAONException {
        ((ConceptInstancesTreeTableModel)getTreeTableModel()).showEntityIndirectly(entity);
    }
    /**
     * Makes sure nothing is shown in the model.
     */
    public void showNothing() {
        ((ConceptInstancesTreeTableModel)getTreeTableModel()).showNothing();
    }
    /**
     * Returns the current entity.
     *
     * @return                      the entity shown
     */
    public Entity getCurrentEntity() {
        return ((ConceptInstancesTreeTableModel)getTreeTableModel()).getCurrentEntity();
    }
    /**
     * Returns the current selection.
     *
     * @return                                  the collection of selected entities
     */
    public Collection getSelection() {
        TreePath[] selectedPaths=getSelectionPaths();
        if (selectedPaths==null)
            return Collections.EMPTY_SET;
        else {
            Collection selection=new HashSet();
            for (int i=0;i<selectedPaths.length;i++) {
                Object object=selectedPaths[i].getLastPathComponent();
                if (object instanceof OIModelNode) {
                    OIModelNode node=(OIModelNode)object;
                    selection.add(node.getObject());
                }
            }
            return selection;
        }
    }
}
