package de.fzi.wim.oimodeler.conceptproperties;

import java.util.HashSet;
import java.util.Collection;
import java.util.List;
import java.util.LinkedList;
import java.util.Iterator;
import java.io.IOException;
import java.awt.Color;
import java.awt.Component;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.datatransfer.UnsupportedFlavorException;
import javax.swing.JViewport;
import javax.swing.table.TableColumn;
import javax.swing.plaf.TableUI;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.api.change.*;

import de.fzi.wim.guibase.dnd.*;
import de.fzi.wim.guibase.selectionsource.*;

import de.fzi.wim.oimodeler.ui.*;
import de.fzi.wim.oimodeler.inspector.*;

/**
 * The table for displaying the property list.
 */
public class ConceptPropertiesTable extends AbstractJTableSelectionSource implements EntityInfoPage {
    /** The OI-modeler viewable. */
    protected OIModelerViewable m_oimodelerViewable;
    /** The drop target. */
    protected ConceptPropertiesDropTarget m_dropTarget;

    /**
     * Creates an instance of this class and attaches it to the editor module.
     *
     * @param oimodelerViewable                             the OI-modeler viewable
     * @param showPropertiesFrom                            <code>true</code> if this table should show properties from concept
     */
    public ConceptPropertiesTable(OIModelerViewable oimodelerViewable,boolean showPropertiesFrom) {
        super(oimodelerViewable.getOIModelerSelectionSourceManager(),new ConceptPropertiesTableModel(oimodelerViewable,showPropertiesFrom));
        m_oimodelerViewable=oimodelerViewable;
        new SelectionSourceDragSource(this);
        addToolTipRenderers();
        TableColumn column=getColumnModel().getColumn(0);
        column.setMinWidth(30);
        column.setMaxWidth(30);
        column.setResizable(false);
        m_dropTarget=new ConceptPropertiesDropTarget();
        ToolTipCellRenderer renderer=new ToolTipCellRenderer() {
            protected String getCellText(Object value) {
                if (value==null)
                    return m_oimodelerViewable.getModule().getAppDriver().getLocalizationManager().getPhrase("oimodeler.unlimited");
                else
                    return super.getCellText(value);
            }
        };
        renderer.setHorizontalAlignment(ToolTipCellRenderer.RIGHT);
        setDefaultRenderer(Integer.class,renderer);
    }
    /**
     * Updates the UI.
     */
    public void updateUI() {
        super.updateUI();
        Component parent=getParent();
        if (parent instanceof JViewport)
            parent.setBackground(getBackground());
    }
    /**
     * Overridden to set the color of the enclosing viewport.
     */
    protected void configureEnclosingScrollPane() {
        super.configureEnclosingScrollPane();
        Component parent=getParent();
        if (parent instanceof JViewport)
            parent.setBackground(getBackground());
        if (parent instanceof BorderedViewport)
            m_dropTarget.setBorderedViewport((BorderedViewport)parent);
    }
    /**
     * Overridden to set the non-dragging UI. Drag-and-drop and the UI don't work well together.
     *
     * @param ui                                            the UI (ignored)
     */
    public void setUI(TableUI ui) {
        super.setUI(new SelectionSourceDragSource.NoDragSelectionTableUI());
    }
    /**
     * Sets the current background color. Overridden to update the enclosing viewport's color as well.
     *
     * @param color                                         the color
     */
    public void setBackground(Color color) {
        super.setBackground(color);
        if (getParent() instanceof JViewport)
            getParent().setBackground(color);
    }
    /**
     * Sets the entity that should be shown.
     *
     * @param entity                                        the entity to be shown
     */
    public void showEntity(Entity entity) {
        ((ConceptPropertiesTableModel)getModel()).setConcept((Concept)entity);
    }
    /**
     * Makes sure nothing is shown in the model.
     */
    public void showNothing() {
        ((ConceptPropertiesTableModel)getModel()).showNothing();
    }
    /**
     * Returns the current entity.
     *
     * @return                                              the current entity
     */
    public Entity getCurrentEntity() {
        return ((ConceptPropertiesTableModel)getModel()).getConcept();
    }
    /**
     * Sets the language that should be shown.
     *
     * @param languageURI                                   the language URI
     * @throws KAONException                                thrown if there is an error
     */
    public void setLanguageURI(String languageURI) throws KAONException {
        OIModelerViewable.setFont(languageURI,this);
        ((ConceptPropertiesTableModel)getModel()).setLanguageURI(languageURI);
    }
    /**
     * Disposes of this table.
     */
    public void dispose() {
        ((ConceptPropertiesTableModel)getModel()).dispose();
    }
    /**
     * Returns the current selection.
     *
     * @return                                  the collection of selected entities
     */
    public Collection getSelection() {
        ConceptPropertiesTableModel model=(ConceptPropertiesTableModel)getModel();
        int[] selectedRows=getSelectedRows();
        Collection selection=new HashSet();
        for (int i=0;i<selectedRows.length;i++) {
            Property property=model.getProperty(selectedRows[i]);
            selection.add(property);
        }
        return selection;
    }

    /**
     * The drop target for the table.
     */
    protected class ConceptPropertiesDropTarget extends JTableDropTarget {
        public ConceptPropertiesDropTarget() {
            super(ConceptPropertiesTable.this,null);
        }
        protected boolean acceptsDrag(DropTargetDragEvent dtde) {
            return dtde.isDataFlavorSupported(CollectionSelection.s_objectCollectionFlavor);
        }
        protected boolean processDrop(DropTargetDropEvent dtde) {
            Collection collection;
            try {
                collection=(Collection)dtde.getTransferable().getTransferData(CollectionSelection.s_objectCollectionFlavor);
            }
            catch (IOException ignored) {
                return false;
            }
            catch (UnsupportedFlavorException ignored) {
                return false;
            }
            ConceptPropertiesTableModel model=(ConceptPropertiesTableModel)getModel();
            Concept concept=model.getConcept();
            List list=new LinkedList();
            Iterator iterator=collection.iterator();
            while (iterator.hasNext()) {
                Object object=iterator.next();
                if (object instanceof Property) {
                    Property property=(Property)object;
                    if (model.getTableRowIndex(property)==-1) {
                        ChangeEvent changeEvent;
                        if (model.getShowPropertiesFrom())
                            changeEvent=new AddPropertyDomain(m_oimodelerViewable.getActiveOIModel(),null,property,concept);
                        else
                            changeEvent=new AddPropertyRange(m_oimodelerViewable.getActiveOIModel(),null,property,concept);
                        list.add(changeEvent);
                    }
                }
            }
            if (!list.isEmpty()) {
                m_oimodelerViewable.changeOIModel(list);
                return true;
            }
            else
                return false;
        }
    }
}
