package de.fzi.wim.oimodeler.clipboard;

import java.util.Collection;
import java.io.IOException;
import java.awt.Component;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.datatransfer.UnsupportedFlavorException;

import edu.unika.aifb.kaon.api.*;

import de.fzi.wim.guibase.dnd.*;

import de.fzi.wim.oimodeler.ui.*;
import de.fzi.wim.oimodeler.entitylist.*;

/**
 * The table for the clipboard.
 */
public class ClipboardTable extends OIModelEntityTable {
    /** The language URI. */
    protected String m_languageURI;
    /** The OI-modeler viewable. */
    protected OIModelerViewable m_oimodelerViewable;
    /** The dop target for the table. */
    protected ClipboardTableDropTarget m_dropTarget;

    /**
     * Creates an instance of this class and attaches it to the editor module.
     *
     * @param oimodelerViewable                             the OI-modeler viewable
     */
    public ClipboardTable(OIModelerViewable oimodelerViewable) {
        super(oimodelerViewable,new OIModelEntityTableModel(oimodelerViewable));
        m_oimodelerViewable=oimodelerViewable;
        m_dropTarget=new ClipboardTableDropTarget();
    }
    /**
     * Overridden to set the color of the enclosing viewport.
     */
    protected void configureEnclosingScrollPane() {
        super.configureEnclosingScrollPane();
        Component parent=getParent();
        if (parent instanceof BorderedViewport)
            m_dropTarget.setBorderedViewport((BorderedViewport)parent);
    }
    /**
     * Sets the URI of the language.
     *
     * @param languageURI
     * @throws KAONException                                thrown if there is a problem
     */
    public void setLanguageURI(String languageURI) throws KAONException {
        m_languageURI=languageURI;
        super.setLanguageURI(languageURI);
    }

    /**
     * The drop target for the table.
     */
    protected class ClipboardTableDropTarget extends JTableDropTarget {
        public ClipboardTableDropTarget() {
            super(ClipboardTable.this,null);
        }
        protected boolean acceptsDrag(DropTargetDragEvent dtde) {
            return dtde.isDataFlavorSupported(CollectionSelection.s_objectCollectionFlavor);
        }
        protected boolean processDrop(DropTargetDropEvent dtde) {
            Collection collection;
            try {
                collection=(Collection)dtde.getTransferable().getTransferData(CollectionSelection.s_objectCollectionFlavor);
            }
            catch (IOException ignored) {
                return false;
            }
            catch (UnsupportedFlavorException ignored) {
                return false;
            }
            try {
                OIModelEntityTableModel model=(OIModelEntityTableModel)getModel();
                model.addEntities(collection);
                return collection.isEmpty();
            }
            catch (KAONException e) {
                return false;
            }
        }
    }
}
