package de.fzi.wim.oimodeler.clipboard;

import java.util.Collection;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JButton;
import javax.swing.JScrollPane;

import edu.unika.aifb.kaon.api.*;

import de.fzi.wim.guibase.dnd.*;
import de.fzi.wim.guibase.localization.*;

import de.fzi.wim.oimodeler.ui.*;
import de.fzi.wim.oimodeler.entitylist.*;
import de.fzi.wim.oimodeler.selection.*;
import de.fzi.wim.oimodeler.sidebar.*;

/**
 * The pane for the clipboard.
 */
public class ClipboardPane extends JPanel implements OIModelerSideBar.SideBarElement {
    /** The OI-modeler viewable. */
    protected OIModelerViewable m_oimodelerViewable;
    /** The clipboard table. */
    protected ClipboardTable m_clipboardTable;

    /**
     * Creates an instance of this class.
     *
     * @param oimodelerViewable                 the OI-modeler viewable
     */
    public ClipboardPane(OIModelerViewable oimodelerViewable) {
        super(new GridBagLayout());
        m_oimodelerViewable=oimodelerViewable;
        m_clipboardTable=new ClipboardTable(oimodelerViewable);
        new DoubleClickSelectionFocuser(m_oimodelerViewable,m_clipboardTable);
        LocalizationManager localizationManager=oimodelerViewable.getModule().getAppDriver().getLocalizationManager();
        JButton clearButton=localizationManager.getButton("oimodeler.clear");
        clearButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                clearEntities();
            }
        });
        GridBagConstraints gbc=new GridBagConstraints(0,0,1,1,1.0,0.0,GridBagConstraints.CENTER,GridBagConstraints.BOTH,new Insets(5,5,0,5),0,0);
        gbc.weighty=1.0;
        gbc.gridy++;
        JScrollPane scrollPane=new JScrollPane();
        scrollPane.setViewport(new BorderedViewport());
        scrollPane.setViewportView(m_clipboardTable);
        add(scrollPane,gbc);
        gbc.fill=GridBagConstraints.HORIZONTAL;
        gbc.weighty=0.0;
        gbc.gridy++;
        gbc.insets.bottom=5;
        add(clearButton,gbc);
    }
    /**
     * Disposes of the inspector.
     */
    public void dispose() {
        if (m_clipboardTable!=null) {
            m_clipboardTable.dispose();
            m_clipboardTable=null;
        }
    }
    /**
     * Sets the current language URI.
     *
     * @param languageURI                       the language URI
     * @throws KAONException                    thrown if there is a problem
     */
    public void setLanguageURI(String languageURI) throws KAONException {
        m_clipboardTable.setLanguageURI(languageURI);
    }
    /**
     * Clears the clipboard.
     */
    public void clearEntities() {
        ((OIModelEntityTableModel)m_clipboardTable.getModel()).clearEntities();
    }
    /**
     * Adds specified entities to the clipboard.
     *
     * @param entities                  the entities
     */
    public void addEntities(Collection entities) {
        try {
            ((OIModelEntityTableModel)m_clipboardTable.getModel()).addEntities(entities);
        }
        catch (KAONException e) {
            m_oimodelerViewable.getModule().getAppDriver().displayErrorNotification(e);
        }
    }
    /**
     * Removes specified entities from the model.
     *
     * @param entities                  the entities
     */
    public void removeEntities(Collection entities) {
        ((OIModelEntityTableModel)m_clipboardTable.getModel()).removeEntities(entities);
    }
    /**
     * Returns the label of the element.
     *
     * @return                                  the name of the element
     */
    public String getLabel() {
        return m_oimodelerViewable.getModule().getAppDriver().getLocalizationManager().getPhrase("oimodeler.sidebar.item.clipboard");
    }
    /**
     * Returns the description of the element.
     *
     * @return                                  the description of the element
     */
    public String getDescription() {
        return m_oimodelerViewable.getModule().getAppDriver().getLocalizationManager().getPhrase("oimodeler.sidebar.item.clipboard.description");
    }
    /**
     * Returns the icon of the element.
     *
     * @return                                  the icon of the element
     */
    public Icon getIcon() {
        return null;
    }
    /**
     * Returns the component.
     *
     * @return                                  the component
     */
    public JComponent getComponent() {
        return this;
    }
    /**
     * Called when the element is evicted from the sidebar.
     */
    public void removedFromSideBar() {
    }
}
