package de.fzi.wim.oimodeler.actions;

import java.awt.event.ActionEvent;

import de.fzi.wim.oimodeler.*;

/**
 * Action that determines whether the system objects should be viewed.
 */
public class ViewSystemObjects extends AbstractEditorAction {

    public ViewSystemObjects(OIModelerModule oimodelerModule) {
        super(oimodelerModule,"action.oimodeler.viewSystemObjects");
    }
    public void actionPerformed(ActionEvent e) {
        getViewable().setShowSystemObjects(!getViewable().getShowSystemObjects());
    }
    public void updateAction() {
        setEnabled(commandsAreEnabled());
        setSelected(getViewable()!=null && getViewable().getShowSystemObjects());
    }
}
