package de.fzi.wim.oimodeler.actions;

import java.awt.event.ActionEvent;

import de.fzi.wim.oimodeler.*;

/**
 * Action that determines whether the inspector should be viewed.
 */
public class ViewInspector extends AbstractEditorAction {

    public ViewInspector(OIModelerModule oimodelerModule) {
        super(oimodelerModule,"action.oimodeler.viewInspector");
    }
    public void actionPerformed(ActionEvent e) {
        getViewable().setShowInspector(!getViewable().getShowInspector());
    }
    public void updateAction() {
        setEnabled(commandsAreEnabled());
        setSelected(getViewable()!=null && getViewable().getShowInspector());
    }
}
