package de.fzi.wim.oimodeler.actions;

import java.awt.event.ActionEvent;

import de.fzi.wim.oimodeler.*;

/**
 * Action that determines whether the clipboard should be displayed or not.
 */
public class ViewClipboard extends AbstractEditorAction {

    public ViewClipboard(OIModelerModule oimodelerModule) {
        super(oimodelerModule,"action.oimodeler.viewClipboard");
    }
    public void actionPerformed(ActionEvent e) {
        if (getViewable()!=null)
            getViewable().showClipboardPane(getViewable().isClipboardShown()==false);
    }
    public void updateAction() {
        setEnabled(commandsAreEnabled());
        setSelected(getViewable()!=null && getViewable().isClipboardShown());
    }
}
