package de.fzi.wim.oimodeler.actions;

import java.awt.event.ActionEvent;

import de.fzi.wim.guibase.actions.*;

import de.fzi.wim.oimodeler.*;

/**
 * Action that pins down an inspector to the sidebar.
 */
public class ToggleInspectors extends AbstractEditorAction implements ModalSmartAction {

    public ToggleInspectors(OIModelerModule oimodelerModule) {
        super(oimodelerModule,"action.oimodeler.toggleInspectors");
    }
    public void actionPerformed(ActionEvent e) {
        String actionID=e.getActionCommand();
        String[] elementNames=getViewable().getEntityInspector().getAvailableElementNames();
        for (int i=0;i<elementNames.length;i++)
            if (actionID.equals(elementNames[i])) {
                boolean currentState=getViewable().getEntityInspector().isElementShown(i);
                getViewable().getEntityInspector().setElementVisibility(i,!currentState);
                break;
            }
    }
    public void updateAction() {
        setEnabled(commandsAreEnabled() && getViewable().getEntityInspector().isVisible());
    }
    public String[][] getModalOptions() {
        String[] elementNames=getViewable().getEntityInspector().getAvailableElementNames();
        String[][] result=new String[elementNames.length][2];
        for (int i=0;i<elementNames.length;i++) {
            result[i][0]=elementNames[i];
            result[i][1]=getViewable().getModule().getAppDriver().getLocalizationManager().getPhrase(elementNames[i]);
        }
        return result;
    }
    public boolean isOptionSelected(int optionIndex) {
        return getViewable().getEntityInspector().isElementShown(optionIndex);
    }
}
